/* $Id:$ */
/*******************************************************************************/
/*
 * \file   __globals.h
 * \brief  global variables 
 *
 * \date   2007-09-27
 * \author Sebastian Sumpf <sumpf@os.inf.tu-dresden.de>
 */
/*******************************************************************************/
/* (c) 2007 Technische Universitaet Dresden
 * This file is part of DROPS, which is distributed under the terms of the
 * GNU General Public License 2. Please see the COPYING file for details.
 */
#ifndef ____GLOBALS_H_
#define ____GLOBALS_H_

#include<l4/sys/types.h>
#include<l4/lxMir/lxfreeze.h>

#include <errno.h>
#define COPY_AREA_SIZE L4_SUPERPAGESIZE


typedef struct lx_task_t {
	lx_ds_info_t ds[LX_MAX_DS];
	off_t        ds_offs[LX_MAX_DS];
	unsigned int ds_count;
	l4_taskid_t  task_id;
	l4_taskid_t  caller_id;
	l4_threadid_t back_server_id;
	int fd;
	l4_addr_t     start_eip;
	l4_addr_t     start_esp;
} lx_task_t;


extern l4_threadid_t freezer_id;
extern void *copy_area;

void thread_save(lx_task_t *task);
void thread_restore(lx_task_t *task);
void *linux_malloc(unsigned long size);
void linux_free(void * ptr);

#endif
