/* $Id:$ */
/*******************************************************************************/
/*
 * \file   main.c
 * \brief  startup code
 *
 * \date   2007/09/27
 * \author Sebastian Sumpf <sumpf@os.inf.tu-dresden.de>
 */
/*******************************************************************************/
/* (c) 2007 Technische Universitaet Dresden
 * This file is part of DROPS, which is distributed under the terms of the
 * GNU General Public License 2. Please see the COPYING file for details.
 */
#include <l4/names/libnames.h>
#include <l4/sys/syscalls.h>
#include <l4/util/macros.h>
#include <l4/util/parse_cmd.h>


#include "__lxcalls.h"
#include "lxMir-server.h"

char LOG_tag[9] = LX_FREEZE;

/*******************************************************************************
 *** globals 
 ******************************************************************************/
lx_task_t lx_tasks[LX_MAX_INSTANCES];
l4_threadid_t lx_main_thread;
l4_threadid_t loader_id;
l4semaphore_t lx_clean_sem = L4SEMAPHORE_INIT(1);
lx_ds_t * dstolxds[FREEZE_MAX_DS];
/*******************************************************************************
 *** options 
 ******************************************************************************/
static int opt_events;


static void * malloc(unsigned long size)
{
	if(!size)
		return NULL;
	return l4dm_mem_allocate_named(size, 0, "DICE");
}

static void free(void * ptr)
{
	l4dm_mem_release(ptr);
}

static void * __dsmlib_grow(void ** data)
{
	return l4dm_mem_allocate_named(L4_PAGESIZE, L4RM_MAP, "dsmlib memory");
}

static void __dsmlib_shrink(void * page, void * data)
{
	l4dm_mem_release(page);
}

static int lx_init(void) 
{
	int error;
	lx_task_init();
	
	//init/start paging thread
	if((error = lx_pager_init()))
		return error;
				
	memset((void*)dstolxds, 0, sizeof(lx_ds_t *) * FREEZE_MAX_DS);
	return 0;
}
		
int main(int argc, const char ** argv)
{
	CORBA_Server_Environment env = dice_default_server_environment; 
	int error;

	if ((error = parse_cmdline(&argc, &argv,
	     'e', "events", "enable exit handling via events",
	     PARSE_CMD_SWITCH, 1, &opt_events, 0)))
	{
		switch (error)
		{
			case -1: LOG_printf("Bad parameter for parse_cmdline()\n"); break;
			case -2: LOG_printf("Out of memory in parse_cmdline()\n"); break;
			default: LOG_printf("Error %d in parse_cmdline()\n", error); break;
		}
		return -1;
	}
	
	lx_main_thread = l4_myself();
	
	if(lx_init())
		return -2;

	if(dsmlib_init(__dsmlib_grow, __dsmlib_shrink))
		return -3;

	
	lx_event_init();
	//if(opt_events && lx_event_init())
	//	return 1;
	
	names_register(LX_FREEZE);
	
#if PROFILE
	lx_timer_init();
#endif
	
	if(!names_waitfor_name("LOADER", &loader_id, 30000))
	{
		LOGd(DBG_ERROR, "Dynamic loader LOADER not found -- terminating");
		return -5;
	}

	env.malloc = malloc;
	env.free   = free;
	LOGd(DBG_VERB, "lxfreezer started ["l4util_idfmt"]", l4util_idstr(l4_myself()));
	if_l4dm_lxmir_server_loop(&env);
	return 0;
}

