/* $Id:$ */
/*******************************************************************************/
/*
 * \file   if_lxmir.c
 * \brief  lxMir interface implementation
 *
 * \date   2007/09/27
 * \author Sebastian Sumpf <sumpf@os.inf.tu-dresden.de>
 */
/*******************************************************************************/
/* (c) 2007 Technische Universitaet Dresden
 * This file is part of DROPS, which is distributed under the terms of the
 * GNU General Public License 2. Please see the COPYING file for details.
 */
#include<l4/generic_ts/generic_ts.h>

#include "__types.h"
#include "__lxcalls.h"
#include "lxMir-server.h"
/* TODO: implement pre-copy error handling */

int
if_l4dm_lxmir_prepare_send_component(CORBA_Object _dice_corba_obj,
                                     const l4_taskid_t *task_id,
                                     const l4_threadid_t *back_server_id,
                                     lx_ds_info_t ds[LX_MAX_DS],
                                     l4_uint32_t *count,
                                     CORBA_Server_Environment *_dice_corba_env)
{
	int err = -L4_ENOTFOUND;
	lx_task_t * task;
	
	*count = 0;
	if((err = lx_task_get(*task_id, &task)) < 0 || !task_is_ready(task))
		return err;
	lx_ds_get_ids(task, ds, count);
	
	task_set_state(task, TASK_SEND_PRECOPY);
	task->mir_id         = *_dice_corba_obj;
	task->back_server_id = *back_server_id;
	
	lx_task_remap_ro(task);
	
	return 0;
}


void
if_l4dm_lxmir_pre_copy_error_component(CORBA_Object _dice_corba_obj,
                                       const l4_taskid_t *task_id,
                                       CORBA_Server_Environment *_dice_corba_env)
{
	int err = -L4_ENOTFOUND;
	lx_task_t * task;

	if((err = lx_task_get(*task_id, &task)) < 0)
		return;
	
	task_set_ready(task);
}


void
if_l4dm_lxmir_get_task_ids_component(CORBA_Object _dice_corba_obj,
                                     l4_taskid_t lx_tasks[LX_MAX_INSTANCES],
                                     l4_uint32_t *count,
                                     CORBA_Server_Environment *_dice_corba_env)
{
	lx_task_get_ids(lx_tasks, count);
} 

void
if_l4dm_lxmir_suspend_component(CORBA_Object _dice_corba_obj,
                                const l4_taskid_t *task_id,
                                CORBA_Server_Environment *_dice_corba_env)
{
	l4_umword_t w0 = 0, w1 = 0;
	l4_msgdope_t result;
	int err = -L4_ENOTFOUND;
	lx_task_t *task;

	if((err = lx_task_get(*task_id, &task)) < 0 || 
	    !task_has_state(task, TASK_SEND_PRECOPY)) {
		if_l4dm_lxmir_suspend_done_send(_dice_corba_obj, err, 0, 0,
		                                _dice_corba_env);
		return;
	}
	
	l4_ipc_send(task->l4x_signal_id, L4_IPC_SHORT_MSG, w0, w1, L4_IPC_NEVER, 
	            &result);
}

/* check if ds state is still valid */
void
if_l4dm_lxmir_update_ds_info_component (CORBA_Object _dice_corba_obj,
                                        const l4_taskid_t *task_id,
                                        lx_ds_info_t ds[LX_MAX_DS],
                                        l4_uint32_t *count,
                                        CORBA_Server_Environment *_dice_corba_env)
{
	int i;
	lx_task_t *task;
	lx_ds_t *lxds;

	if(lx_task_get(*task_id, &task) < 0)
		return;

	for(i = 0; i < *count; i++) 
	{
		if(lx_ds_get(task, ds[i].ds_id, &lxds) == -L4_ENOTFOUND)
			ds[i].flags = DS_INFO_INVALID;
	}
}


int
if_l4dm_lxmir_post_copy_component (CORBA_Object _dice_corba_obj,
                                   const l4_taskid_t *task_id,
                                   unsigned long *ds_id,
                                   unsigned long *offset,
                                   void **page,
                                   l4_size_t *size,
                                   CORBA_Server_Environment *_dice_corba_env)
{
	lx_task_t * task;

	if(lx_task_get(*task_id, &task) < 0 || 
	   !task_has_state(task, TASK_SEND_POSTCOPY))
		return -L4_ENOTFOUND;

	if(!l4_thread_equal(task->mir_id, *_dice_corba_obj))
		return -L4_EPERM;

	if(task->cow_page_cur == NULL) {
		return 1;
	}

	*ds_id             = task->cow_page_cur->ds_id;
	*offset            = task->cow_page_cur->offs;
	*page              = (void*)task->cow_page_cur->map_addr;
	*size              = L4_PAGESIZE;
	task->cow_page_cur = task->cow_page_cur->next;
	
#if DS_CHECKSUM
	lx_ds_t * lxds;
	if(lx_ds_get(task, *ds_id, &lxds) >= 0) {
		memcpy((void*)lxds->map_addr + *offset, *page, L4_PAGESIZE);
		lxds->flags |= LX_POSTCPY;
	}
#endif 

	return 0;
}


void
if_l4dm_lxmir_back_end_done_component(CORBA_Object _dice_corba_obj,
                                      const l4_taskid_t *task_id,
                                      CORBA_Server_Environment *_dice_corba_env)
{
	lx_task_t * task;
	if(lx_task_get(*task_id, &task) < 0)
		return;
	
	if(task_has_state(task, TASK_SEND_POSTCOPY)) { 
		dbg_lx_ds_hash(task);
		lxif_exit_task(*task_id);
	}
}

int
if_l4dm_lxmir_prepare_recv_component(CORBA_Object _dice_corba_obj,
                                     const l4_threadid_t *back_server_id,
                                     const lx_ds_info_t ds[50],
                                     l4_uint32_t *count,
                                     l4_addr_t start_eip, l4_addr_t start_esp,
                                     l4_taskid_t *new_instance,
                                     CORBA_Server_Environment *_dice_corba_env)
{
	l4_uint32_t i;
	int err;
	lx_task_t * task;
	lx_ds_t * lxds;
	lx_page_fault_t fault;

	if((err = l4ts_allocate_task(new_instance)))
		return err;
	
	err = lx_task_add(*new_instance);
	if(err < 0) 
	{
	  l4ts_free_task(new_instance);
	  return err;
	}
	
	lx_task_get_pos(err, &task);
	task->mir_id         = *_dice_corba_obj;
	task->back_server_id = *back_server_id;
	task->state          = TASK_MIGRATED;
	task_set_state(task, TASK_RECV_PRECOPY);
	task->start_eip      = start_eip;
	task->start_esp      = start_esp;

	for(i = 0; i < *count; i++) 
	{
		if(ds[i].flags  == DS_INFO_INVALID)
			continue;
		/* TODO:
		 *       - cleanup on error 
		 */
		if((err = lxif_open(*new_instance, ds[i].size, 0, 0, ds[i].name, &lxds)))
			return err;
		
		lxds->virt_ds_id = ds[i].ds_id;
		if(ds[i].flags & DS_INFO_VIRT)
		{
			fault.ds_id     = ds[i].ds_id;
			fault.virt_addr = ds[i].virt_addr;
			fault.virt_size = ds[i].virt_size;
			fault.flags     = 0;
			
			lx_pager_add_ds(task, fault);

			if(ds[i].virt_addr == L4ENV_INFOPAGE_AT)
				task->lx_infopage = (l4env_infopage_t *)lxds->map_addr;
		}
  }
	return 0;
}





















