/* vi: set sw=4 ts=4: */
/*
 * chroot() for uClibc
 *
 * Copyright (C) 2000-2006 Erik Andersen <andersen@uclibc.org>
 *
 * Licensed under the LGPL v2.1, see the file COPYING.LIB in this tarball.
 */

#include "syscalls.h"
#include <unistd.h>
#include <string.h>
#include <sys/param.h>

#define __NR___syscall_chroot __NR_chroot
static inline _syscall1(int, __syscall_chroot, const char *, path);

int chroot(const char *path)
{
	return __syscall_chroot(path);
}
