#!/usr/bin/perl -w

# generate an index.html file that contains links to documentation
#
# arguments: <output-file> <header> <footer> [title-files ...]

use strict;
use Fcntl ':mode';
use IO::Handle;
#use CGI qw/:standard *table start_ul thead tfoot tbody start_tbody colgroup/;
#use CGI::Pretty qw( :html3 );
use CGI::Pretty;

my $http = new CGI;
# lists with the link target directories
my (@files_guide, @files_ref, @files_int, @files_unsorted);
# the following hashes are indexed by the link targets in the previous lists
my %titles;	# the titles of the documentation
my %names;	# the short-hand names for the links

# Provide help on cmdline arguments
#
# arg:
# $cmd	- the name of the executable
sub help{
    my $cmd = $0;

    $cmd =~ s/.*\///;
    print(STDERR "$cmd  <output-file> <header> <footer> [title-files ...]\n\n");
    print(STDERR "title-file format:\n",
	         "  1. line: type ('guide', 'ref', 'int' or empty)\n",
                 "  2. line: title (nonempty!)\n\n");
    print(STDERR "Links are grouped by the type of the title files as found in the first line:\n");
    print(STDERR "guide -> User guides\n");
    print(STDERR "ref   -> Reference Manuals\n");
    print(STDERR "int   -> Internal Documentation\n");
    print(STDERR "(nil) -> Others\n");
    exit(1);
}

# Add a file to the internal structures
#
# arg: the name of the file
#
# we have a hash  %titles that maps the names to title
# we have the 4 lists @files_{guide,ref,int,unsorted} where the names
# are strored.
sub addfile{
    my $file = shift @_;
    my $title;	# the title as it will appear in the html-file
    my $name;	# the short-hand name for the link
    my $type;	# the type of the docu (guide, ref, int, (unsorted))

    open(FILE, $file) || die ("Cannot open \"",$file,"\"");
    $type=<FILE>;
    $title=<FILE>;
    close(FILE);
    chomp($type) if defined $type;
    chomp($title) if defined $title;
    if(!$title){
	print(STDERR
	      "Invalid format in \"",$file,"\".\n");
	help();
    }
    # strip the .title from the filename. This results in the link target
    $file =~ s/\.title$//;
    # strip a leading path from the filename. This is the short-hand link name
    $name = $file;
    $name =~ s/^.*\///;
    $titles{$file}=$title;
    $names{$file}=$name;
    if ($type eq "guide"){
	push(@files_guide , $file);
    } elsif ($type eq "ref"){
	push(@files_ref , $file);
    } elsif ($type eq "int"){
	push(@files_int , $file);
    } else {
	push(@files_unsorted , $file);
    }
}

# dump a type of documentation
# args: #1 - reference to the list
#       #2 - the section title
sub dumplist{
    my $list = shift @_;
    my $sectitle = shift @_;
    my $file;

    if($#$list>=0){
	@$list = sort @$list;
        printf(OUTPUT
	       $http->TR($http->th({align=>"left", colspan=>2},
				   $http->h2($sectitle))));
        foreach $file (@$list){
            print(OUTPUT
                  $http->TR($http->td($http->a({href=>$file."/index.html"},
                                               $names{$file})) .
                            $http->td($titles{$file})));
	}
    }
}

###############################################
#
#  We start here
#
###############################################

my ($output, $header, $footer,  $file);
my @argv;

@argv = @ARGV;

$output = shift @argv;
$header = shift @argv;
$footer = shift @argv;

help() if !$footer;

while($#argv>=0){
	$file = shift @argv;
	addfile($file);
}

open(OUTPUT, ">$output");
open(IN,$header) || die ("Unable to open \"", $header, "\"");
while(<IN>){ print(OUTPUT $_);}
close(IN);

print(OUTPUT $http->start_table);
dumplist(\@files_guide, "User Guides");
dumplist(\@files_ref, "Reference Manuals");
dumplist(\@files_int, "Internal Documentation");
dumplist(\@files_unsorted, "Various documentation");
print(OUTPUT $http->end_table);

open(IN,$footer) || die ("Unable to open \"", $footer, "\"");
while(<IN>){ print(OUTPUT $_);}
close(IN);
close(OUTPUT);
