/**
 *    \file    dice/src/fe/FEResourceDeclarator.cpp
 *    \brief    contains the implementation of the class CFEResourceDeclarator
 *
 *    \date    04/25/2004
 *    \author    Ronald Aigner <ra3@os.inf.tu-dresden.de>
 */
/* Copyright (C) 2001-2003 by
 * Dresden University of Technology, Operating Systems Research Group
 *
 * This file contains free software, you can redistribute it and/or modify
 * it under the terms of the GNU General Public License, Version 2 as
 * published by the Free Software Foundation (see the file COPYING).
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * For different licensing schemes please contact
 * <contact@os.inf.tu-dresden.de>.
 */
#include "fe/FEResourceDeclarator.h"
#include "fe/FEResourceProperty.h"

#include "File.h"

IMPLEMENT_DYNAMIC(CFEResourceDeclarator);

CFEResourceDeclarator::CFEResourceDeclarator(String *pName, Vector *pProperties)
 : CFEInterfaceComponent(),
   m_vResourceProperties(RUNTIME_CLASS(CFEResourceProperty))
{
    IMPLEMENT_DYNAMIC_BASE(CFEResourceDeclarator, CFEInterfaceComponent);
    if (pName)
        m_sName = *pName;
    m_vResourceProperties.Add(pProperties);
}

CFEResourceDeclarator::CFEResourceDeclarator(CFEResourceDeclarator &src)
 : CFEInterfaceComponent(src),
   m_vResourceProperties(RUNTIME_CLASS(CFEResourceProperty))
{
    IMPLEMENT_DYNAMIC_BASE(CFEResourceDeclarator, CFEInterfaceComponent);
    m_sName = src.m_sName;
    m_vResourceProperties.Add(&src.m_vResourceProperties);
    m_vResourceProperties.SetParentOfElements(this);
}

/** destroys the resource declarator object */
CFEResourceDeclarator::~CFEResourceDeclarator()
{
}

/**    \brief creates a copy of this class
 *    \return a reference to the copy of this class
 */
CObject* CFEResourceDeclarator::Clone()
{
    return new CFEResourceDeclarator(*this);
}

/**    \brief serialize resource to a file
 *    \param pFile the file to write to
 */
void CFEResourceDeclarator::Serialize(CFile *pFile)
{
    *pFile << "\t<resource>\n";
    pFile->IncIndent();
    *pFile << "\t<name>" << m_sName << "</name>\n";
    *pFile << "\t<properties>\n";
    pFile->IncIndent();

    VectorElement *pIter = GetFirstProperty();
    CFEResourceProperty *pProperty;
    while ((pProperty = GetNextProperty(pIter)) != 0)
    {
        pProperty->Serialize(pFile);
    }

    pFile->DecIndent();
    *pFile << "\t</properties>\n";
    pFile->DecIndent();
    *pFile << "\t</resource>\n";
}

/**    \brief get pointer  to first property
 *    \return pointer to first property
 */
VectorElement* CFEResourceDeclarator::GetFirstProperty()
{
    return m_vResourceProperties.GetFirst();
}

/**    \brief return the reference to the next property
 *    \param a pointer to the next property
 *    \return a reference to the next property
 */
CFEResourceProperty* CFEResourceDeclarator::GetNextProperty(VectorElement* &pIter)
{
    if (!pIter)
        return NULL;
    CFEResourceProperty *pRet = (CFEResourceProperty*)pIter->GetElement();
    pIter = pIter->GetNext();
    if (!pRet)
        return GetNextProperty(pIter);
    return pRet;
}

/*!
    \fn CFEResourceDeclarator::GetName()
    \return the value of the resource name string
 */
String CFEResourceDeclarator::GetName()
{
    return m_sName;
}
