/**
 *    \file    dice/src/be/BEResourceRequestFunction.h
 *    \brief    contains the declaration of the class CBEResourceRequestFunction
 *
 *    \date    04/25/2004
 *    \author    Ronald Aigner <ra3@os.inf.tu-dresden.de>
 */
/* Copyright (C) 2001-2003 by
 * Dresden University of Technology, Operating Systems Research Group
 *
 * This file contains free software, you can redistribute it and/or modify
 * it under the terms of the GNU General Public License, Version 2 as
 * published by the Free Software Foundation (see the file COPYING).
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * For different licensing schemes please contact
 * <contact@os.inf.tu-dresden.de>.
 */
#ifndef BERESOURCEREQUESTFUNCTION_H
#define BERESOURCEREQUESTFUNCTION_H

#include <be/BEInterfaceFunction.h>

class CFEResourceDeclarator;

/**
 *    \class CBEResourceRequestFunction
 *    \ingroup backend
 *    \brief wraps a function to make a resource reservation
 */
class CBEResourceRequestFunction : public CBEInterfaceFunction
{
DECLARE_DYNAMIC(CBEResourceRequestFunction);
public:
    /** creates a resource request function */
    CBEResourceRequestFunction();
    virtual ~CBEResourceRequestFunction();

    virtual bool CreateBackEnd(CFEInterface *pFEInterface, CBEContext *pContext);
    virtual bool DoWriteFunction(CBEFile * pFile, CBEContext * pContext);
    virtual int GetReceiveDirection();
    virtual int GetSendDirection();

protected:
    /** copy constructor
     *    \param src the original to copy from
     */
    CBEResourceRequestFunction(CBEResourceRequestFunction &src);

    virtual bool AppendResource(CFEResourceDeclarator *pFEResource, CBEContext *pContext);

    /** \var String m_sRequest
     *    \brief the request string
     */
    String m_sRequest;
};

#endif
