.\"Warning: don't edit this file. It has been generated by typeset
.\" The next compilation will silently overwrite all changes.
.TH "l4_thread_schedule" 1 "27.06.96" "Institut" "User Commands"
.SH NAME
 l4_thread_schedule \-  Define priority, timeslice length and external preempter of
other threads.

.SH " Synopsis"
.nf
\fB#include <l4/sys/syscalls.h>\fP
.fi
.PP
\fBstatic inline volatile l4_cpu_time_t\fP 
.br
\fBl4_thread_schedule(l4_threadid_t \fP\fIdest\fP \fB,
l4_sched_param_t \fP \fIparam\fP \fBl4_threadid_t\fP
\fI*ext_preempter\fP \fB, l4_threadid_t\fP \fI*partner\fP \fB,
l4_sched_param_t \fP \fI*old_param\fP \fB);\fP

.SH " Description"
The \fBl4_thread_schedule()\fP system call can be used by schedulers to
define priority, timeslice length and external preempter of other
threads. Furthermore it delivers thread states.
.PP
The system call is only effective, if the current priority of the
specified destination is less than or equal to the current task's
maximum controlled priority (mcp).
.SH " Arguments"
.IP "\fIdest\fP"
The identifier of the destination thread. The 
destination thread must currently exist and run on a priority level
less than or equal to the current thread's mcp.
.IP "\fIparam\fP"
This word specifies scheduling parameters:
.nf
\fBtypedef struct {
  unsigned prio:8;
  unsigned small:8;
  unsigned zero:4;
  unsigned time_exp:4;
  unsigned time_man:8;
} l4_sched_param_struct_t;

typedef union {
  l4_umword_t sched_param;
  l4_sched_param_struct_t sp;
} l4_sched_param_t;\fP
.fi
.IP
If \fB0xFFFFFFFF\fP is given, the thread's current scheduling
parameters are not modified.
.IP
Otherwise, the value contains the following parameters:
.RS
.IP " \fBprio\fP "
The thread's static system\-wide priority. 255 is the
highest and 0 the lowest priority.
.IP " \fBsmall\fP"
The number and size of the small address space assigned to the thread,
if any. All small address spaces have the same size. Once a thread
get assigned a new size, all previous assignments automatically become
invalid. Possible sizes are 2, 4, 8, ... 256 megabytes. Valid
numbers are 1 .. (512/size_MB)\-1.
.IP
Valid small address space specifiers can be built using the macro
L4_SMALL_SPACE(size_MB, nr).
.IP " \fBzero\fP Reserved, must be zero."
.IP " \fBtime_man, time_exp\fP Timeslice length, specified in timeout
format (see  l4_ipc )."
.RE
.IP "\fI*ext_preempter\fP"
The id of the external preempter for the
thread. \fBIf L4_INVALID_ID\fP is given, the current external preempter of
the thread is not changed.
.IP "\fI*partner\fP"
Id of a partner of an active user\-invoked ipc
operation. This parameter is only valid, if the thread's user state is
sending, receiving, pending or waiting. \fBL4_INVALID_ID\fP is delivered if
there is no specific partner, i.e. if the thread is in an open receive
state.
.IP "\fI*old_param\fP"
This value contains the old priority, timeslice
length, state and priority of the destination thread. For an exact
description of the format refer to the L4 Reference Manual.
.IP
If \fB0xFFFFFFFF\fP is delivered, the addressed thread does
either not exist or has a priority which exceeds the current thread's mcp.
.SH "Return Values"
The returned 64 bit value contains the following information
(beginning with most significant bit):
.IP "\fImw\fP (8 bits), \fIew\fP (4 bits)"
Current user\-level wakeup of the
destination thread, encoded like a timeout. The value denotes the
still remaining timeout intervall. Valid only if the user state is
waiting or pending.
.IP "\fIep\fP (4 bits)"
Effective pagefault wakeup of the destination thread,
encoded like a 4\-bit pagefault timeout. The value denotes the still
remaining timeout interval. Valid only if the kernel state is pager.
.IP "\fIT\fP (48 bits)"
Cpu time in microseconds which has been consumed by
the destination thread.
.SH "See Also"
 l4_thread_ex_regs ,  l4_myself ,  l4_nchief ,  l4_thread_switch ,  l4_fpage_unmap ,  l4_task_new  
