#ifndef __ASM_L4__ARCH_I386__UNISTD_H__
#define __ASM_L4__ARCH_I386__UNISTD_H__

/* make sure __KERNEL_SYSCALLS isn't defined for <asm-i386/unistd.h> */
#ifdef __KERNEL_SYSCALLS__
# define __ASM_L4_I386_UNISTD_H__KERNEL_SYSCALLS__
# undef  __KERNEL_SYSCALLS__
#endif

#include <asm-i386/unistd.h>

#ifdef __ASM_L4_I386_UNISTD_H__KERNEL_SYSCALLS__
# undef  __ASM_L4_I386_UNISTD_H__KERNEL_SYSCALLS__
# define __KERNEL_SYSCALLS__
#endif

#ifdef __KERNEL_SYSCALLS__

#include <linux/compiler.h>
#include <linux/types.h>
#include <linux/linkage.h>
#include <asm/ptrace.h>

#undef _syscall0
#undef _syscall1
#undef _syscall2
#undef _syscall3
#undef _syscall4
#undef _syscall5
#undef _syscall6

#define __Ksyscall_return(type, res)					\
	do {								\
		if ((unsigned long)(res) >= (unsigned long)(-(128 + 1))) {	\
			errno = -(res);					\
			res = -1;					\
		}							\
		return (type) (res);					\
	} while (0)

#define __Ksyscall0(type, name) 					\
	type name(void)							\
	{								\
		long __res = __SC__##name();				\
		__Ksyscall_return(type, __res);				\
	}

#define __Ksyscall1(type, name, type1, arg1)				\
	type name(type1 arg1)						\
	{								\
		long __res = __SC__##name(arg1);			\
		__Ksyscall_return(type, __res);				\
	}

#define __Ksyscall2(type, name, type1, arg1, type2, arg2)		\
	type name(type1 arg1, type2 arg2)				\
	{								\
		long __res = __SC__##name(arg1, arg2);			\
		__Ksyscall_return(type, __res);				\
	}

#define __Ksyscall3(type, name, type1, arg1, type2, arg2, type3, arg3)	\
	type name(type1 arg1, type2 arg2, type3 arg3)			\
	{								\
		long __res = __SC__##name(arg1, arg2, arg3);		\
		__Ksyscall_return(type, __res);				\
	}

/*
 * WARNING: if any of the following ones want and/or modify struct
 *          pt_regs on its stack, we lose!
 */

asmlinkage inline long __SC__setsid(void)
	asm("sys_setsid");
asmlinkage inline long __SC__write(int fd, const char * buf, off_t count)
	asm("sys_write");
asmlinkage inline long __SC__read(int fd, const char * buf, off_t count)
	asm("sys_read");
asmlinkage inline long __SC__lseek(int fd, off_t offset, int count)
	asm("sys_lseek");
asmlinkage inline long __SC__dup(int fd)
	asm("sys_dup");
asmlinkage inline long __SC__open(const char *file, int flag, int mode)
	asm("sys_open");
asmlinkage inline long __SC__close(int fd)
	asm("sys_close");
asmlinkage inline long __SC__waitpid(pid_t pid, int *wait_stat, int options)
	asm("sys_waitpid");

extern inline __Ksyscall0(pid_t,setsid)
extern inline __Ksyscall3(int,write,int,fd,const char *,buf,off_t,count)
extern inline __Ksyscall3(int,read,int,fd,char *,buf,off_t,count)
extern inline __Ksyscall3(off_t,lseek,int,fd,off_t,offset,int,count)
extern inline __Ksyscall1(int,dup,int,fd)

extern inline __Ksyscall3(int,open,const char *,file,int,flag,int,mode)
extern inline __Ksyscall1(int,close,int,fd)

extern inline __Ksyscall3(pid_t,waitpid,pid_t,pid,int *,wait_stat,int,options)

/* Implemented in arch/l4/kernel/process.c */
int execve(char *file, char **argv, char **envp);


#endif /* __KERNEL_SYSCALLS__ */

#endif /* ! __ASM_L4__ARCH_I386__UNISTD_H__ */
