#ifndef __L4_SIGMA0_SIGMA0_H
#define __L4_SIGMA0_SIGMA0_H

#include <l4/sys/compiler.h>
#include <l4/sys/types.h>

#undef SIGMA0_REQ_MAGIC
#undef SIGMA0_REQ_MASK

# define SIGMA0_REQ_MAGIC		~0xFFUL
# define SIGMA0_REQ_MASK		~0xFFUL

/* Starting with 0x60 allows to detect components which still use the old
 * constants (0x00 ... 0x50) */
#define SIGMA0_REQ_ID_MASK		  0xF0
#define SIGMA0_REQ_ID_FPAGE_RAM		  0x60
#define SIGMA0_REQ_ID_FPAGE_IOMEM	  0x70
#define SIGMA0_REQ_ID_FPAGE_IOMEM_CACHED  0x80
#define SIGMA0_REQ_ID_FPAGE_ANY		  0x90
#define SIGMA0_REQ_ID_KIP		  0xA0
#define SIGMA0_REQ_ID_TBUF		  0xB0

#define SIGMA0_IS_MAGIC_REQ(d1)	\
  ((d1 & SIGMA0_REQ_MASK) == SIGMA0_REQ_MAGIC)

#define SIGMA0_REQ(x) \
  (SIGMA0_REQ_MAGIC + SIGMA0_REQ_ID_ ## x)

/* Use these constants in your code! */
#define SIGMA0_REQ_FPAGE_RAM		  (SIGMA0_REQ(FPAGE_RAM))
#define SIGMA0_REQ_FPAGE_IOMEM		  (SIGMA0_REQ(FPAGE_IOMEM))
#define SIGMA0_REQ_FPAGE_IOMEM_CACHED	  (SIGMA0_REQ(FPAGE_IOMEM_CACHED))
#define SIGMA0_REQ_FPAGE_ANY		  (SIGMA0_REQ(FPAGE_ANY))
#define SIGMA0_REQ_KIP			  (SIGMA0_REQ(KIP))
#define SIGMA0_REQ_TBUF			  (SIGMA0_REQ(TBUF))

EXTERN_C_BEGIN

int l4sigma0_map_mem(l4_threadid_t pager,
		     l4_addr_t phys, l4_addr_t virt, l4_addr_t size);

int l4sigma0_map_iomem(l4_threadid_t pager, l4_addr_t phys,
		       l4_addr_t virt, l4_addr_t size, int cached);

int l4sigma0_map_anypage(l4_threadid_t pager, l4_addr_t map_area,
			 unsigned log2_map_size, l4_addr_t *base);

int l4sigma0_map_tbuf(l4_threadid_t pager, l4_addr_t virt);

static inline char *l4sigma0_map_errstr(int err)
{
  switch (err)
    {
    case  0: return "No error";
    case -1: return "Phys, virt or size not aligned";
    case -2: return "IPC error";
    case -3: return "No fpage received";
#ifndef SIGMA0_REQ_MAGIC
    case -4: return "Bad physical address (old protocol only)";
#endif
    case -6: return "Superpage requested but smaller flexpage received";
    case -7: return "Cannot map I/O memory cacheable (old protocol only)";
    default: return "Unknown error";
    }
}

EXTERN_C_END

#endif /* ! __L4_SIGMA0_SIGMA0_H */
