#include "capdescriptor.h"

void CapDescriptor::add_cap(unsigned int dest)
{
	if (!has_cap(dest))
		_caps.push_back(dest);
}

void CapDescriptor::remove_cap(unsigned int task)
{
	if (has_cap(task))
		_caps.erase(&task);
}

bool CapDescriptor::has_cap(unsigned int task)
{
	std::vector<unsigned int>::iterator it = _caps.begin();

	while (*it)
	{
		if (*it == task)
			return true;
		*it++;
	}

    return false;
}

unsigned CapDescriptor::num_caps()
{
	return this->_caps.size();
}

unsigned CapDescriptor::task()
{
	return this->_task;
}
