#include <iostream>
#include <string>

using namespace std;

#include <sys/ioctl.h>
#include <fcntl.h>

#include <l4/sys/types.h>
#include <l4/sys/kdebug.h>

void
usage(void)
{
  cout << "usage:\n"
    "sysctl profile [ start | dump | stop ]\n";
  exit(1);
}

void
use_debug_idt()
{
  int fn;

  emulib_info_struct emu_info;

  if (0 > (fn = open("/proc/l4/ctl", O_RDWR)))
    {
      cerr << "unable to open '/proc/l4/ctl'\n";
      exit(1);
    }
  
  if (ioctl(fn, L4GETEMUINFO, &emu_info))
    {
      cerr << "unable to execute ioctl on '/proc/l4/ctl'\n";
      exit(1);
    }
  close(fn);

  asm("lidt (%%eax)" : : "a" (emu_info.emulib_debug_idt_descr));
}

void
profile(const string &command)
{
  // Before we can use the kdb interface, we must clear out our INT3
  // idt entry.
  use_debug_idt();

  if (command == "start")
    {
      cout << "starting kernel profiling\n";
      fiasco_profile_start();
    }
  else if (command == "dump")
    {
      cout << "stopping kernel profiling, and dumping\n";
      fiasco_profile_stop_and_dump();
    }
  else if (command == "stop")
    {
      cout << "stopping kernel profiling\n";
      fiasco_profile_stop();
    }
  else 
    usage();
}

int
main(int argc, char **argv)
{
  if (argc != 3)
    usage();

  if (string(argv[1]) == "profile")
    profile(argv[2]);

  else usage();

  return 0;
}
