IMPLEMENTATION [{ia32,ux}-debug]:

#include <cstring>
#include "types.h"

IMPLEMENT
void Kip::print() const
{
  unsigned kips = kip_sys_calls;
  static char const* const KIPS[] = {"No KIP syscalls supported",
				     "KIP syscalls via KIP relative stubs",
				     "KIP syscalls via absolute stubs",
				     "KIP syscalls ERROR: bad value"};

  if(kips>3)
    kips = 3;

  printf("magic: %.4s  version: 0x%x\n",(char*)&magic,version);
  printf("root memory:     [" L4_PTR_FMT "; " L4_PTR_FMT ")\n"
         "sigma0 memory:   [" L4_PTR_FMT "; " L4_PTR_FMT ")\n"
         "sigma1 memory:   [" L4_PTR_FMT "; " L4_PTR_FMT ")\n"
	 "main memory:     [" L4_PTR_FMT "; " L4_PTR_FMT ")\n"
	 "reserved[0..1]:  [" L4_PTR_FMT "; " L4_PTR_FMT ")\n"
         "                 [" L4_PTR_FMT "; " L4_PTR_FMT ")\n"
	 "semi reserved:   [" L4_PTR_FMT "; " L4_PTR_FMT ")\n"
	 "dedicated[0..3]: [" L4_PTR_FMT "; " L4_PTR_FMT ")\n"
	 "                 [" L4_PTR_FMT "; " L4_PTR_FMT ")\n"
	 "                 [" L4_PTR_FMT "; " L4_PTR_FMT ")\n"
	 "                 [" L4_PTR_FMT "; " L4_PTR_FMT ")\n",
	 L4_PTR_ARG(root_memory.start), L4_PTR_ARG(root_memory.end),
	 L4_PTR_ARG(sigma0_memory.start), L4_PTR_ARG(sigma0_memory.end),
	 L4_PTR_ARG(sigma1_memory.start), L4_PTR_ARG(sigma1_memory.end),
	 L4_PTR_ARG(main_memory.start), L4_PTR_ARG(main_memory.end),
	 L4_PTR_ARG(reserved0.start), L4_PTR_ARG(reserved0.end),
	 L4_PTR_ARG(reserved1.start), L4_PTR_ARG(reserved1.end),
	 L4_PTR_ARG(semi_reserved.start), L4_PTR_ARG(semi_reserved.end),
	 L4_PTR_ARG(dedicated[0].start), L4_PTR_ARG(dedicated[0].end),
	 L4_PTR_ARG(dedicated[1].start), L4_PTR_ARG(dedicated[1].end),
	 L4_PTR_ARG(dedicated[2].start), L4_PTR_ARG(dedicated[2].end),
	 L4_PTR_ARG(dedicated[3].start), L4_PTR_ARG(dedicated[3].end));

  printf("clock: " L4_X64_FMT " (%lld)\n", clock, clock);
  printf("freq_cpu: %ldkHz\n", frequency_cpu);
  printf("freq_bus: %ldkHz\n", frequency_bus);

  printf("sigma0_ip: "L4_PTR_FMT" sigma0_sp: "L4_PTR_FMT"\n", sigma0_ip, sigma0_sp);
  printf("sigma1_ip: "L4_PTR_FMT" sigma1_sp: "L4_PTR_FMT"\n", sigma1_ip, sigma1_sp);
  printf("root_ip:   "L4_PTR_FMT" root_sp:   "L4_PTR_FMT"\n", root_ip,   root_sp);


  printf("%s\n",KIPS[kips]);

  Mword
    s_ipc = sys_ipc,
    s_id_n= sys_id_nearest,
    s_fpu = sys_fpage_unmap,
    s_tsw = sys_thread_switch,
    s_tsc = sys_thread_schedule,
    s_lex = sys_lthread_ex_regs,
    s_tn  = sys_task_new;

  switch(kips)
    {
    default:
      break;
    case 1:
      printf("The following addresses are offsets in the KIP\n");
    case 2:
      printf("  ipc:             " L4_PTR_FMT "\n"
	     "  id nearest:      " L4_PTR_FMT "\n"
	     "  fpage unmap:     " L4_PTR_FMT "\n"
	     "  thread switch:   " L4_PTR_FMT "\n"
	     "  thread schedule: " L4_PTR_FMT "\n"
	     "  lthread ex regs: " L4_PTR_FMT "\n"
	     "  task new:        " L4_PTR_FMT "\n",
	     L4_PTR_ARG(s_ipc), L4_PTR_ARG(s_id_n),
	     L4_PTR_ARG(s_fpu), L4_PTR_ARG(s_tsw),
	     L4_PTR_ARG(s_tsc), L4_PTR_ARG(s_lex),
	     L4_PTR_ARG(s_tn) );

      break;
    }

  char const *s = version_string();

  printf("Kernel features:");
  for (s += strlen(s) + 1; *s; s += strlen(s) + 1)
    printf(" %s", s);
  puts("");

  printf("user_ptr: %p\n", (void*)user_ptr);

}
