/**
 *    \file    dice/src/fe/FEResourceDeclarator.h
 *    \brief    contains the declaration of the class CFEResourceDeclarator
 *
 *    \date    04/25/2004
 *    \author    Ronald Aigner <ra3@os.inf.tu-dresden.de>
 */
/* Copyright (C) 2001-2003 by
 * Dresden University of Technology, Operating Systems Research Group
 *
 * This file contains free software, you can redistribute it and/or modify
 * it under the terms of the GNU General Public License, Version 2 as
 * published by the Free Software Foundation (see the file COPYING).
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * For different licensing schemes please contact
 * <contact@os.inf.tu-dresden.de>.
 */
#ifndef FERESOURCEDECLARATOR_H
#define FERESOURCEDECLARATOR_H

#include <fe/FEInterfaceComponent.h>
#include "Vector.h"
#include "CString.h"

class CFEResourceProperty;

/**
 *    \class CFEResourceDeclarator
 *    \brief represents one resource requirement of an interface
 *    \ingroup frontend
 */
class CFEResourceDeclarator : public CFEInterfaceComponent
{
DECLARE_DYNAMIC(CFEResourceDeclarator);
public:
    /** creates a resource declarator object */
    CFEResourceDeclarator(String *pName, Vector *pProperties);
    ~CFEResourceDeclarator();

    virtual void Serialize(CFile *pFile);
    virtual VectorElement* GetFirstProperty();
    virtual CFEResourceProperty* GetNextProperty(VectorElement* &pIter);
    virtual String GetName();
    virtual CObject* Clone();

protected:
    /** copy constructor
     *    \param src the source to copy from
     */
    CFEResourceDeclarator(CFEResourceDeclarator &src);

    /** \var Vector m_vResourceProperties
     *    \brief contains the properties of the resource
     */
    Vector m_vResourceProperties;
    /**    \var String m_sName
     *    \brief the name of the resource
     */
    String m_sName;
};

#endif
