#include <stdio.h>
#include <stdlib.h>
#include <l4/names/libnames.h>
#include "vtpm-server.h"
#include "vtpmif.h"

#ifdef __cplusplus
extern "C" {
#endif

int l4libc_heapsize = 32*1024;
	
/**
 * A simple rand_buffer function. Used as workaround until real random is available.
 */

int randseed;
int rand_buffer(char *dest, int count)
{
	int i;
	for (i=0; i < count; i++)
		dest[i]=randseed++;
	return count;
}

/**
 * Allocation functions for dst parameter
 */
void *CORBA_alloc(unsigned long size){
	return malloc(size);
}
void CORBA_free(void *addr){
	free(addr);
}


CORBA_int
vtpmif_add_component(CORBA_Object _dice_corba_obj,
                     const l4_threadid_t *taskid,
                     const l4_threadid_t *parentid,
                     const_CORBA_char_ptr name,
                     const_CORBA_char_ptr hash,
                     CORBA_Server_Environment *_dice_corba_env)
{
	return vtpm_add(*_dice_corba_obj,*taskid,*parentid,name,hash);
}



CORBA_int
vtpmif_del_component(CORBA_Object _dice_corba_obj,
                     const l4_threadid_t *taskid,
                     CORBA_Server_Environment *_dice_corba_env)
{
	return vtpm_del(*_dice_corba_obj,*taskid);
}



CORBA_int
vtpmif_link_component(CORBA_Object _dice_corba_obj,
                      const l4_threadid_t *taskid,
                      CORBA_int keylen,
                      const CORBA_char *key,
                      CORBA_int *dstlen,
                      CORBA_char **dst,
                      CORBA_Server_Environment *_dice_corba_env)
{
  *dstlen = vtpm_link(*taskid,keylen,key,*dstlen,*dst);
	return *dstlen;
}



CORBA_int
vtpmif_quote_component(CORBA_Object _dice_corba_obj,
                       const l4_threadid_t *taskid,
                       CORBA_int nlen,
                       const CORBA_char *nonce,
                       CORBA_int *dstlen,
                       CORBA_char **dst,
                       CORBA_Server_Environment *_dice_corba_env)
{
  *dstlen = vtpm_quote(*taskid,nlen,nonce,*dstlen,*dst);
	return *dstlen;
}



CORBA_int
vtpmif_seal_component(CORBA_Object _dice_corba_obj,
                      const l4_threadid_t *taskid,
                      CORBA_int hashlen,
                      const CORBA_char *hash,
                      CORBA_int srclen,
                      const CORBA_char *src,
                      CORBA_int *dstlen,
                      CORBA_char **dst,
                      CORBA_Server_Environment *_dice_corba_env)
{
  *dstlen = vtpm_seal(*taskid,hashlen,hash,srclen,src,*dstlen,*dst);
	return *dstlen;
}



CORBA_int
vtpmif_unseal_component(CORBA_Object _dice_corba_obj,
                        const l4_threadid_t *taskid,
                        CORBA_int srclen,
                        const CORBA_char *src,
                        CORBA_int *dstlen,
                        CORBA_char **dst,
                        CORBA_Server_Environment *_dice_corba_env)
{
  *dstlen = vtpm_unseal(*taskid,srclen,src,*dstlen,*dst);
  return *dstlen;
}

int main(void)
{
	CORBA_Server_Environment env=dice_default_server_environment;

	if (names_register(vtpmif_name) == 0)
	{
		printf("Error registering at nameserver\n");
		return 1;
	}

	env.malloc=CORBA_alloc;
	env.free=CORBA_free;
	vtpmif_server_loop(&env);
}


#ifdef __cplusplus
}
#endif

