#include <l4/stpm/vtpm-client.h>
#include <l4/stpm/vtpmif.h>
#include <l4/stpm/encap.h>

CHECK_SERVER(vtpmif_name);

ENCAP_FUNCTION(vtpm,
	       add,
	       (l4_threadid_t owner_id,
		l4_threadid_t new_id,
		l4_threadid_t parent_id,
		const char *name,
		const char *hash)
	       ,
	       &new_id,
	       &parent_id,
	       name,
	       hash);
		     

ENCAP_FUNCTION(vtpm,
	       del,
	       (l4_threadid_t owner_id,
		l4_threadid_t new_id)
	       ,
	       &new_id);

ENCAP_FUNCTION(vtpm,
	       link,
	       (l4_threadid_t id,
		int keylen,
		const char *key,
		int dstlen,
		char *dst)
	       ,
	       &id,
	       keylen,
	       key,
	       &dstlen,
	       &dst);

ENCAP_FUNCTION(vtpm,
	       quote,
	       (l4_threadid_t id,
		int nlen,
		const char *nonce,
		int dstlen,
		char *dst),
	       &id,
	       nlen,
	       nonce,
	       &dstlen,
	       &dst);

ENCAP_FUNCTION(vtpm,
	       seal,
	       (l4_threadid_t id,
		int hashlen,
		const char *hash,
		int srclen,
		const char *src,
		int dstlen,
		char *dst),
	       &id,
	       hashlen,
	       hash,
	       srclen,
	       src,
	       &dstlen,
	       &dst);

ENCAP_FUNCTION(vtpm,
	       unseal,
	       (l4_threadid_t id,
		int srclen, 
		const char *src,
		int dstlen,
		char *dst),
	       &id,
	       srclen,
	       src,
	       &dstlen,
	       &dst);
