
#include "global.h"
#include "rsaref.h"

typedef R_RSA_PRIVATE_KEY privkey_t;
typedef R_RSA_PUBLIC_KEY pubkey_t;
typedef R_RANDOM_STRUCT random_t;

typedef struct
{
	privkey_t priv;
	pubkey_t  pub;
	random_t random;
} rsa_key_t;

#define RSA_SIGSIZE MAX_SIGNATURE_LEN
#define RSA_HASHSIZE 20


int
rsa_sign(rsa_key_t *key, int dstlen, char *dst, ...);

int
rsa_create(rsa_key_t *key, int bits);

int
rsa_insertrandom(rsa_key_t *key, int srclen, char *src);

int
rsa_encrypt(rsa_key_t *key, int dstlen, char *dst, ... );

int
rsa_decrypt(rsa_key_t *key, int dstlen, char *dst, ...);

