#ifndef _STPM_VTPMIF_H
#define _STPM_VTPMIF_H

#include <l4/sys/types.h>

#define vtpmif_name "vtpm"


typedef struct 
{
	l4_threadid_t id;
	l4_threadid_t parent;
	char name[40];
  unsigned char hash[20];
} vtpm_data_t;

typedef struct 
{
	vtpm_data_t data;
	char sig[128];
} vtpm_quote_t;




int
vtpm_add    (l4_threadid_t owner_id,
	     l4_threadid_t new_id,
	     l4_threadid_t parent_id,
	     const char *name,
	     const char *hash);

int 
vtpm_del    (l4_threadid_t owner_id,
	     l4_threadid_t new_id);

int
vtpm_link   (l4_threadid_t id,
	     int keylen,
	     const char *key,
	     int dstlen,
	     char *dst);

int
vtpm_quote  (l4_threadid_t id,
	     int nlen,
	     const char *nonce,
	     int dstlen,
	     char *dst);

int
vtpm_seal(l4_threadid_t id,
	  int hashlen,
	  const char *hash,
	  int srclen, 
	  const char *src,
	  int dstlen,
	  char *dst);

int
vtpm_unseal(l4_threadid_t id, 
	    int srclen,
	    const char *src, 
	    int dstlen,
	    char *dst);

#endif
