/****************************************************************************/
/*                                                                          */
/* OIAPOSAP.H 03 Apr 2003                                                   */
/*                                                                          */
/* This file is copyright 2003 IBM. See "License" for details               */
/****************************************************************************/
#ifndef OIAPOSAP_H
#define OIAPOSAP_H

#include <tcg/tpm.h>
#include <tcg/rand.h>
#include <tcg/hmac.h>


typedef struct osapsess {
    unsigned long handle;
    unsigned char enonce[TCG_NONCE_SIZE];
    unsigned char enonceOSAP[TCG_NONCE_SIZE];
    unsigned char ononceOSAP[TCG_NONCE_SIZE];
    unsigned char ssecret[TCG_HASH_SIZE];
    unsigned char ononce[TCG_NONCE_SIZE];
} osapsess;

unsigned long TPM_OIAP(unsigned long *handle, char *enonce);
unsigned long TPM_OSAP(osapsess *sess, unsigned char *key, unsigned short etype,
                  unsigned long evalue);
unsigned long TPM_Terminate_Handle(unsigned long handle);

/**
 * Defines an authenticated transmit function, which is used several times in
 * the lib, e.g. TPM_ClearOwner
 */
#define TPM_TRANSMIT_OSAP_FUNC(NAME,PARAMS,KEY_AUTH,KEY_TYPE,KEY_VALUE,OSAPCOND,PRECOND,POSTCOND,AUTHFMT,FMT,...)\
unsigned long TPM_##NAME PARAMS {              \
  unsigned char buffer[TCG_MAX_BUFF_SIZE]; /* request/response buffer */ \
  unsigned char nonceodd[TCG_NONCE_SIZE];      \
  unsigned char pubauth[TCG_HASH_SIZE];        \
  osapsess sess;                               \
  unsigned long ret;                           \
  unsigned char c;                             \
                                               \
  OSAPCOND                                     \
                                               \
  if (KEY_AUTH==0)                             \
       return -10;                             \
  ret = TPM_OSAP(&sess, KEY_AUTH, KEY_TYPE,KEY_VALUE); \
  if (ret)                                     \
    return ret;                                \
  rand_buffer(nonceodd, TCG_NONCE_SIZE);       \
  c = 0;                                       \
                                               \
  PRECOND                                      \
                                               \
  /* try to build the param buffer */          \
  ret = buildbuff(AUTHFMT,buffer, __VA_ARGS__);\
  if (ret < 0) {                               \
   TPM_Terminate_Handle(sess.handle);          \
   return -20;                                 \
  }                                            \
                                               \
  /* hash the param buffer */                  \
  ret=authhmac(pubauth,                        \
	       sess.ssecret, TCG_HASH_SIZE,    \
	       sess.enonce, nonceodd, &c,      \
               ret, buffer,                    \
	       0,0);                           \
  if (ret < 0) {                               \
   TPM_Terminate_Handle(sess.handle);          \
   return -30;                                 \
  }                                            \
  ret = buildbuff("00 C2 T " FMT " L % o %",   \
		  buffer,                      \
                  __VA_ARGS__,                 \
		  sess.handle,                 \
		  TCG_NONCE_SIZE, nonceodd,    \
		  c,                           \
		  TCG_HASH_SIZE, pubauth);     \
 if (ret < 0) {                                \
   TPM_Terminate_Handle(sess.handle);          \
   return -40;                                 \
 }                                             \
 ret = TPM_Transmit(buffer, #NAME );           \
 if (ret != 0) {                               \
   TPM_Terminate_Handle(sess.handle);          \
   return ret;                                 \
 }                                             \
                                               \
 POSTCOND                                      \
                                               \
 TPM_Terminate_Handle(sess.handle);            \
 return ret;                                   \
}

#endif
