#ifndef _SHA_H
#define _SHA_H

/**
 * Access to crypto routines.
 *
 * The defines are not identically with openssl, but nearly the same.
 */

#ifdef LINUX

#include <openssl/sha.h>
#include <openssl/hmac.h>

typedef SHA_CTX SHA1_CTX;
typedef HMAC_CTX HMAC1_CTX;

#else

#include "sha1.h"

typedef SHA1Context SHA1_CTX;

struct hmac_handle
{
  SHA1_CTX hmac;
  SHA1_CTX hash;
};

typedef struct hmac_handle HMAC1_CTX;
#endif // not LINUX


int SHA1_init  (SHA1_CTX * ctx);
int SHA1_update(SHA1_CTX * ctx, void * value, int len);
int SHA1_final (SHA1_CTX * ctx, void * output);

int HMAC_SHA1_init(HMAC1_CTX * ctx, void * key,    int keylen);
int HMAC_update   (HMAC1_CTX * ctx, void * value,  int len);
int HMAC_final    (HMAC1_CTX * ctx, void * output, int *len);

#endif
