#include <stdio.h>
#include <string.h>
#include <assert.h>
#include <ctype.h>
#include "vtpmif.h"

int l4libc_heapsize = 64*1024;

void print_error(int no,char *text)
{
	if (no)
		printf("%s: %s\n",text,strerror(no));
}

int rand_buffer(char *dest, int count)
{
	int i;
	for (i=0; i < count; i++)
		dest[i]=i;
	return count;
}


int test_seal()
{

	int res;
        char *value="1234567890";
	unsigned char data[1024];
	int datalen=sizeof(data);
	l4_threadid_t new;

	
	new   .id.task=0x22;

	res=vtpm_seal(new,0,NULL,strlen(value),value,datalen,data);
	printf("vtpm_seal() = %0d\n",res);
	{
		int i;
		for (i=0;i<res;i++)
			printf("%02x",data[i]);
		printf("\n");
	}

	return res;
}


int test_quote()
{
  int res;
  
  l4_threadid_t new;
  unsigned char data[1024];
  int datalen=sizeof(data);
  char *nounce = "nounce";
  
  new.id.task=0x20;
  res = vtpm_quote(new,strlen(nounce), nounce, datalen, data);
	       
  printf("\nvtpm_quote() = %0d\n",res);
  {
    int i;
    for (i=0;i<res;i++)
      printf("%02x",data[i]);
    printf("\n");
    for (i=0;i<res;i++)
	printf("%c", isgraph(data[i]) ? data[i]: '.');
    printf("\n");
  }

  return res;
}

int main(int argcm, char **argv)
{
	
	int res;	
	l4_threadid_t owner, new, parent;	

	printf("vtpmtest start!\n");

	owner .id.task=0x10;
	new   .id.task=0x20;
	parent.id.task=0x30;

	res=vtpm_add(owner,new,parent,"test1","first hash");
	print_error(res,"vtpm_add() 1");

	new.id.task=0x21;
	res=vtpm_add(owner,new,parent,"test2","next hash!");
	print_error(res,"vtpm_add() 2");

	new.id.task=0x22;
	res=vtpm_add(owner,new,parent,"test3","12345");
	print_error(res,"vtpm_add() 3");

	res=vtpm_count();
	assert(res==3);

	new.id.task=0x21;

	res=vtpm_del(owner,new);
	print_error(res,"vtpm_del()");

	res=vtpm_count();	
	assert(res==2);

	res=test_seal();
	assert(res>0);

	res=test_quote();
	assert(res>=0);

	printf("\nvtpmtest done!\n");

	return 0;
}
