#include <netinet/in.h>
#include <tcg/tpm.h>
#include <tcg/ord.h>
#include <tcg/transmit.h>
#include <tcg/buildbuff.h>

TPM_TRANSMIT_FUNC(SHA1Start,
		  (unsigned long *value),
		  ,
		  *value = ntohl(((unsigned long*)(buffer+TCG_DATA_OFFSET))[0]); ,
		  "L",
		  TPM_ORD_SHA1Start);


TPM_TRANSMIT_FUNC(SHA1Update,
		  (unsigned char *data, unsigned long datalen),
		  ,
		  ,
		  "L @",
		  TPM_ORD_SHA1Update,
		  datalen,data);

TPM_TRANSMIT_FUNC(SHA1Complete,
		  (unsigned char *data, unsigned long datalen, unsigned char *hash),
		  ,
		  memcpy(hash, buffer+TCG_DATA_OFFSET, TCG_HASH_SIZE);
		  ,
		  "L @",
		  TPM_ORD_SHA1Complete,
		  datalen,data);
