/**
 * Basic tcg functions.
 */

#include <tcg/tpm.h>
#include <tcg/ord.h>
#include <tcg/basic.h>

/**
 * Get a trival property from the tpm.
 */
#define TPM_TRANSMIT_FUNC_GET_PROP(name,prop) \
        TPM_TRANSMIT_FUNC(name, (unsigned long *value), , \
			  if (TPM_EXTRACT_LONG(0)!=4) \
			  return -2; \
			  *value=TPM_EXTRACT_LONG(4); , \
			  "L L L L", \
			  TPM_ORD_GetCapability, \
			  TPM_CAP_PROPERTY, \
			  TPM_SUBCAP, \
			  prop);

/**
 * Reset the TPM.
 */
TPM_TRANSMIT_FUNC(Reset, (void), , , "L", TPM_ORD_Reset);

/**
 * Get the version of the tpm.
 */
TPM_TRANSMIT_FUNC(GetCapability_Version,
		  (int *major, int *minor, int *version,int *rev),
		  ,
		  if (TPM_EXTRACT_LONG(0)!=4)
  		      return -2;
		  *major = (int)(buffer[TCG_DATA_OFFSET+4]);
		  *minor = (int)(buffer[TCG_DATA_OFFSET+5]);
		  *version = (int)(buffer[TCG_DATA_OFFSET+6]);
		  *rev = (int)(buffer[TCG_DATA_OFFSET+7]);
		  ,
		  "L L L",
		  TPM_ORD_GetCapability,
		  TPM_CAP_VERSION,
		  TPM_NO_SUBCAP);


/**
 * Get the number of the available key slots.
 */			  			  
TPM_TRANSMIT_FUNC_GET_PROP(GetCapability_Slots,TPM_CAP_PROP_SLOTS);

/**
 * Get the number of the pcrs.
 */			  			  
TPM_TRANSMIT_FUNC_GET_PROP(GetCapability_Pcrs,TPM_CAP_PROP_PCR);

/**
 * Get all loaded keys.
 */
TPM_TRANSMIT_FUNC(GetCapability_Key_Handle,
		  (unsigned short *num, unsigned long keys[]),
		  ,
                  {
			  int i;
			  *num=TPM_EXTRACT_SHORT(4);
			  for(i=0;i<*num;i++)
				  keys[i]=TPM_EXTRACT_LONG(6+4*i); 
		  },
		  "L L L",
		  TPM_ORD_GetCapability,
		  TPM_CAP_KEY_HANDLE,
		  TPM_NO_SUBCAP);

TPM_TRANSMIT_FUNC(Startup, (unsigned short value), , , "L S", TPM_ORD_Startup,value);
TPM_TRANSMIT_FUNC(SaveState, (void), , , "L", TPM_ORD_SaveState);
TPM_TRANSMIT_FUNC(ForceClear, (void), , , "L", TPM_ORD_ForceClear);
TPM_TRANSMIT_FUNC(PhysicalPresence, (void), , , "40 00 00 0A o 08",0);
TPM_TRANSMIT_FUNC(PhysicalEnable, (void), , , "L",0x6F);
