#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>
#include <fcntl.h>

#include <l4/log/l4log.h>
#include <l4/env/errno.h>
#include <l4/util/l4_macros.h>

#include "bmi-client.h"
#include "bmilx-server.h"
#include "bmi-server.h"
#include <l4/cbbmi/bmi.h>



extern "C" {

void
bmilx_shutdownPD_component (CORBA_Object _dice_corba_obj,
                            CORBA_Server_Environment *_dice_corba_env)
{

    //LOGd(dbgbmilx,"(bmilx:" l4util_idfmt "): SHUTDOWN start !\n",l4util_idstr(l4_myself()));
    char * const new_argv[] = {"/sbin/poweroff",NULL};
    int ret = execve("/sbin/poweroff",new_argv,NULL);
    LOGd(dbgbmilx,"(bmilx): SHUTDOWN end !\n");
}


}

int main(int argc, char **argv)
{
    LOGd(dbgbmilx,"(bmilx) Main START. \n");

    /* Find the BMI */
    DICE_DECLARE_ENV(env);
    l4_threadid_t id_cbbmi = get_bmi_id();

    LOGd(dbgbmilx,"(bmilx) BMI found (%u.%u)\n",id_cbbmi.id.task, id_cbbmi.id.lthread);
   

    /* Retrieve the pdid from the command line parameters. */
    char cmdline[4096];
    int fd = open("/proc/cmdline",O_RDONLY);
    if(fd<0)
    {
        LOG("(bmilx): Failed to open /proc/cmdline.\n");
        return 1;
    }
    
    int num_bytes = read(fd,cmdline,4096);
    if(num_bytes <= 0)
    {
        LOG("(bmilx): Failed to read from /proc/cmdline.\n");
        return 1;
    }
    
    int islx = 0;
    int hasparam=0;

    cmdline[num_bytes-1] = 0;
    char *pos = strstr(cmdline,"pdid=");
    if(pos!=NULL)
        islx = 1;

    char *pos2 = strstr(cmdline,"this=");
    if(pos2!=NULL)
        hasparam=1;

    LOG("******************+\n(bmilx)\n islx(%d) hasparam(%d) for (%u.%u)\n*******************\n",
        islx,hasparam,l4_myself().id.task,l4_myself().id.lthread);

    if(pos==NULL)
    {
        LOG("(bmilx): pdid not given in kernel command line.\n");
        return 1;
    }
    
   // char *pos = strstr(cmdline,"pdid=");
    if(pos==NULL)
    {
        LOG("(bmilx): pdid not given in kernel command line.\n");
        return 1;
    }

    char subs[32];

    int i=0;
    while(pos[i+5]!=' ' && pos[i+5]!=0)
    {
        subs[i] = pos[i+5];
        i++;
    }
    subs[i] = 0;

    int rpdid = atoi(subs);

    LOGd(dbgbmilx,"(bmilx): position(%s)\n",pos);
    LOGd(dbgbmilx,"(bmilx): pdid(%d)\n",rpdid);
    

    /* Register at the BMI  */ 
    l4_threadid_t myself = l4_myself();
    LOGd(dbgbmilx,"(bmilx) ME(%u.%u) PDID(%d)\n",
         myself.id.task, 
         myself.id.lthread,
         rpdid);

    int res = bmi_receiveName_call(&id_cbbmi, rpdid, &myself, "bmilxserv", &env);

    LOGd(dbgbmilx,"(bmilx) Main END. \n");
    
    bmilx_server_loop(0);

    return 0;
}
