#include <stdio.h>
#include <l4/sys/types.h>
#include <l4/names/libnames.h>
#include <l4/sys/syscalls.h>
#include <l4/env/errno.h>
#include <l4/loader/loader-client.h>

#include "bmi-local.h"

PDEntry::PDEntry(l4_threadid_t myid)
{
    pdname = "";
    l4id = myid;
    pdid = -1;
    prio = 0;
    isl4lx=0;
    bmilx = bmilx_global;
}

PDEntry::PDEntry() : pdname(""), l4id(L4_INVALID_ID), bmilx(bmilx_global), isl4lx(0), minmem(-1), maxmem(-1), mincpu(1), maxcpu(1)
{
    status_caps[PAUSE] = SHUTDOWN;
    status_caps[RESTART] = RUNNING;
    status_caps[SUSPEND] = SHUTDOWN;
    status_caps[RESUME] = RUNNING;
}


int registerPD(PDEntry* entry, PDEntry* pds_map[])
{
    int i=0;
    while(pds_map[i]!=NULL)
    {
        i++;
        if(i==MAX_PDS)
        {
            return -1;
        }
    }
    
    entry->pdid = i;
    pds_map[i] = entry;
    
    return i;
}


