#include <stdio.h>
#include <malloc.h>

#include<l4/dm_mem/dm_mem.h>
#include<l4/names/libnames.h>
#include<l4/loader/loader-client.h>
#include<l4/log/l4log.h>
#include<l4/env/env.h>
#include<l4/env/errno.h>
#include<l4/util/util.h>
#include<l4/generic_ts/generic_ts.h>


#include<l4/cbbmi/bmi.h>

#include "bmi-server.h"
#include "bmi-local.h"
#include "bmilx-client.h"

static PDEntry* pds_map[MAX_PDS];

l4_threadid_t bmilx_global = L4_INVALID_ID;

void printPDs()
{
    LOG("(bmi) >>>>> LIST_PDEntries START <<<<<\n");
    int i=0;
    while(i<MAX_PDS)
    {
        if(pds_map[i])
        {
           LOG("(bmi) >>>> PDID[%d] - l4id[%u.%u] - bmilx[%u.%u] - status[%d] - size[%x]\n",
               pds_map[i]->pdid,
               (pds_map[i]->l4id).id.task,
               (pds_map[i]->l4id).id.lthread,
               (pds_map[i]->bmilx).id.task,
               (pds_map[i]->bmilx).id.lthread,
               pds_map[i]->status,
	       pds_map[i]->size);
           
        }
        i++;

    }

    LOG("(bmi) >>>>> LIST_PDEntries END <<<<<\n");
}


PDPolicy::PDPolicy(int tid, int con_map)
{
    dest = tid;
    conmap = con_map;
}


int
startPD_intern(int pdid)
{

    LOGd(dbgbmi,"(bmi) Starting internally PD(%d)...\n",pdid);

    /* Check that this PD was initialized */
    if(!(pdid>=0 && pdid<MAX_PDS && pds_map[pdid]!=NULL))
    {
        LOG("(bmi) PD(%d) has not been registered yet !\n",pdid); 
        return -L4_EINVAL;
    }

    else
        LOGd(dbgbmi,"(bmi) PD(%d) was registered !\n",pdid); 

    /* Find the dataspace manager called "DM_PHYS" */
    l4_threadid_t dm_phys_id;
    dm_phys_id = L4_INVALID_ID;
    if (!names_waitfor_name("DM_PHYS", &dm_phys_id, 3000))
    {
        LOG("(bmi) DM_PHYS not found!\n");
        return -1;
    }

    else
        LOGd(dbgbmi,"(bmi) DM_PHYS found!\n");

    /* Create a new dataspace where the config parameters 
     * for the new PD will be stored */
    l4_size_t ds_size = 0x1000;
    l4_addr_t ds_align = 0;
    l4_uint32_t ds_flags = 0;

    l4dm_dataspace_t ds = L4DM_INVALID_DATASPACE;

    int ds_create = l4dm_mem_open(dm_phys_id,
                                  ds_size,
                                  ds_align,
                                  ds_flags,
                                  "ds_bmi",
                                  &ds);


    if(l4dm_dataspace_equal(ds,L4DM_INVALID_DATASPACE))
    {
        LOG("(bmi) Invalid dataspace after creation. \n");
    }
    
    else
        LOGd(dbgbmi,"(bmi) Valid dataspace created. \n");

    /* Attach the dataspace to the bmi_server
     */
    l4_offs_t ds_offset = 0;
    char* ds_addr = 0;

    int ds_attach = l4rm_attach(&ds,
                                ds_size,
                                ds_offset,
                                ds_flags,
                                (void**)&ds_addr);

   
    /* Check if the task to be started is a L4Linux task. */
    char *pos = strstr(pds_map[pdid]->data,"l4linux-");
    
    int n=0;

    if(pos==NULL)
    {
        LOGd(dbgbmi,"(bmi): (%s) is NOT a L4Linux task.\n",pds_map[pdid]->data);

        /* Append all the provided command line parameters to the cfg string.*/
        //char* data = pds_map[pdid]->data;
        char datanew[MAX_IMAGE_DATA_LENGTH];
        char cmdparams[MAX_CMDLINE_LENGTH];



        int i=0;
        while((pds_map[pdid]->data)[i]!='$')
        {
            datanew[i] = (pds_map[pdid]->data)[i];
            i++;
        }
        datanew[i] = '\0';
        i++;

        LOG("(bmi) INIT DATANEW(%s)\n",datanew);

        int j=0;
        while( (pds_map[pdid]->data)[i] && (pds_map[pdid]->data)[i]!='$')
        {
            cmdparams[j] = (pds_map[pdid]->data)[i];
            j++;
            i++;
        }
        cmdparams[j] = '\0';
        LOG("(bmi) DATA:(%s)\n DATANEW(%s)\n CMDPARAMS(%s)\n",
            pds_map[pdid]->data, datanew, cmdparams);


	 /* 
	  * Write the config string for the new PD at the dataspace 
	  * located at ds_addr 
	  */
        n = snprintf(ds_addr, ds_size, "task \"%s\" \"%s\"\n",datanew, cmdparams);
    }
    else
    {
        LOGd(dbgbmi,"(bmi): (%s) is a L4Linux task.\n",pds_map[pdid]->data);
    
        char subs[MAX_IMAGE_DATA_LENGTH];
        int i=0;
        while(pos[i+8]!=' ' && pos[i+8]!=0)
        {
            subs[i] = pos[i+8];
            i++;
        }
        subs[i] = 0;

	 /* 
	  * Write the config string for the new PD at the dataspace 
	  * located at ds_addr 
	  */
        n = snprintf(ds_addr, ds_size, "task \"%s\" \"no-scroll earlyprintk=yes mem=%dM pdid=%d root=/dev/ram load_ramdisk=1 ramdisk_size=6144 l4env_rd=image-bbmi.rd l4ore.instances=ORe:lo l4ore.irqnum=13 ip=192.168.0.%d\"\npriority 0x90\nall_sects_writable\n",subs,(pds_map[pdid]->pddesc).mem,pdid,pdid+10);
    }

    /* Find the loader called "LOADER"
     * */
    l4_threadid_t loader_id;
    loader_id = L4_INVALID_ID;

    if (!names_waitfor_name("LOADER", &loader_id, 3000))
    {
        LOG("(bmi) LOADER not found!\n");
        return -1;
    }


    /* Grant RW rights for the dataspace to the loader 
     * */
    int res_grant = l4dm_share(&ds,
                               loader_id,
                               L4DM_RW);


    /* Transfer ownership to loader 
     * */
    int res_transfer = l4dm_transfer(&ds,
                                     loader_id);
                          
    /* Give the ds start address to the loader
     * */
    DICE_DECLARE_ENV(env);
    const char* task_name = "taskname";
    static char error_msg[1024];
    char* ptr = error_msg;
    
    static l4_taskid_t task_ids[l4loader_MAX_TASK_ID];

    int i=0;
    for(i=0; i<l4loader_MAX_TASK_ID; i++)
    {
        task_ids[i] = L4_INVALID_ID;
    }

    l4env_infopage_t * l4env_infopage = l4env_get_infopage();
    if (!l4env_infopage)
      {
	LOG("(bmi) no L4env infopage\n");
	return -1;
      }
    if (l4_thread_equal(l4env_infopage->fprov_id, L4_INVALID_ID))
      {
	LOG("(bmi) no FPROV in infopage\n");
	return -1;
      }

    int res_open_hi = l4loader_app_open_call(&loader_id,
                                             &ds,
                                             task_name,
                                             &l4env_infopage->fprov_id,
                                             0,          //flags: L4LOADER_STOP or cont()
                                             task_ids,   
                                             &ptr,       //error_msg
                                             &env);
    if(res_open_hi)
    {
        LOG("(bmi) Asking loader for task creation failed!\n");
        return -1;
    }

    /* Check that the new task has been created
     */
    if(l4_is_invalid_id(task_ids[0]))
    {
        LOG("(bmi) Task creation did not succeed!\n");
        return -1;
    }
    else
        LOGd(dbgbmi,"(bmi) Valid task (%u.%u) created.\n",
             task_ids[0].id.task,
             task_ids[0].id.lthread);
    
    /* Register the l4_threadid_t for this PDEntry 
     * */
    pds_map[pdid]->l4id = task_ids[0];
   
    /* Set status of PDEntry to "RUNNING" (1) */
    pds_map[pdid]->status = RUNNING;


    LOGd(dbgbmi,"(bmi) PD(%d) was indeed created!\n",pdid);
    
    return 0;

}


extern "C" {


int
bmi_hasPDID_component(CORBA_Object _dice_corba_obj,
                      int pdid, 
                      int* hasid,
                      CORBA_Server_Environment *_dice_corba_env)
{

    *hasid = 0;

    if(pdid>=0 && pdid<MAX_PDS && pds_map[pdid]!=NULL)
    {
        *hasid = 1;
    }
    
    return 0;
}


       
int
bmi_receiveName_component(CORBA_Object _dice_corba_obj,
                          int rpdid,
                          const l4_threadid_t* tid,
                          const char* name,
                          CORBA_Server_Environment *_dice_corba_env)
{
    
    /* Check that it is the bmilx */
    if(!(strcmp(name,"bmilxserv")))
    {
        LOG("(bmi) BMILXSERV registering for PDID(%d) with l4_threadid(%u.%u)\n",
            rpdid,
            (*tid).id.task,
	    (*tid).id.lthread);


        if(rpdid>=0 && rpdid<MAX_PDS && pds_map[rpdid]!=NULL)
        {
            /* Register the bmilx for this PD. */
            pds_map[rpdid]->bmilx = (*tid);
        }


        bmilx_global = *tid;

        /* Register the bmilx_id for all the running PDs */

        LOG("(bmi): bmilx1(%u.%u) \n",
            bmilx_global.id.task,
            bmilx_global.id.lthread);
    
    
        //printPDs();


        return 0;
    }

    else
    {
        return 1;
    }
}


int
bmi_killPD_component(CORBA_Object _dice_corba_obj,
                     int pdid,
                     CORBA_Server_Environment *_dice_corba_env)
{

    if(pdid>=0 && pdid<MAX_PDS && pds_map[pdid]!=NULL)
    {
        /* Kill the PD */
        l4_threadid_t pdold = pds_map[pdid]->l4id;
        l4_threadid_t me = l4_myself();
        

        LOGd(dbgbmi,"(bmi): [1] me(%u.%u) KILL(%u.%u) START\n",
            me.id.task,
            me.id.lthread,
            pdold.id.task,
            pdold.id.lthread);

        int killres = l4ts_kill_task_recursive(pdold);

        LOGd(dbgbmi,"(bmi): [2] me(%u.%u) KILL(%u.%u) ACTION \n",
            me.id.task,
            me.id.lthread,
            pdold.id.task,
            pdold.id.lthread);


        LOGd(dbgbmi,"(bmi): [3] me(%u.%u) KILL(%u.%u) END\n",
            me.id.task,
            me.id.lthread,
            pdold.id.task,
            pdold.id.lthread);

        /* Delete the PDEntry for this PD */
        pds_map[pdid]=NULL;

        return 0;
    }
   
    else
    {
        LOG("(bmi) The killing process was not performed\n");
        return -L4_EINVAL;
    }
}


int
bmi_lookupThreadid_component (CORBA_Object _dice_corba_obj,
                              int pdid,
                              l4_threadid_t* l4id,
                              CORBA_Server_Environment *_dice_corba_env)
{
    *l4id = L4_INVALID_ID;
    
    if(pdid>=0 && pdid<MAX_PDS && pds_map[pdid]!=NULL)
    {
        *l4id = pds_map[pdid]->l4id;
        return 0;
    }

    return -L4_EINVAL;
}


int
bmi_lookupPDID_component (CORBA_Object _dice_corba_obj,
                          const l4_threadid_t* myid,
                          int* pdid,
                          CORBA_Server_Environment *_dice_corba_env)
{
    *pdid = -2;

    int i=0;
    while(i<MAX_PDS)
    {
        if(pds_map[i] && l4_thread_equal(pds_map[i]->l4id,*myid))
        {
            *pdid = pds_map[i]->pdid;
            return 0;
        }
        i++;
    }

    return -2;
}
 


int
bmi_getStatus_component (CORBA_Object _dice_corba_obj,
                         int pdid,
                         int* pdstatus,
                         CORBA_Server_Environment *_dice_corba_env)
{
    int res = -2;
    if(pdid>=0 && pdid<MAX_PDS && pds_map[pdid]!=NULL)
    {
        *pdstatus = (int)(pds_map[pdid]->status); 
        res = 0;
    }

    return res;
}
    

int
bmi_getVersion_component (CORBA_Object _dice_corba_obj,
                          int* version,
                          CORBA_Server_Environment *_dice_corba_env)
{
    *version = ( (bmi_major_version << 16) | bmi_minor_version ) ;
    return 0;
}


int
bmi_getPrio_component (CORBA_Object _dice_corba_obj,
                       int pdid,
                       int* priority,
                       CORBA_Server_Environment *_dice_corba_env)
{
    int res = -2;
    if(pdid>=0 && pdid<MAX_PDS && pds_map[pdid]!=NULL)
        *priority = pds_map[pdid]->prio;
   
    return 0; 
    
}

int
bmi_setPrio_component (CORBA_Object _dice_corba_obj,
                       int pdid,
                       int newprio,
                       CORBA_Server_Environment *_dice_corba_env)
{
    int res = -2;
    if(pdid>=0 && pdid<MAX_PDS && pds_map[pdid]!=NULL)
    {
        pds_map[pdid]->prio = newprio;
        res = 0;
    }
    return res;
}

int
bmi_setStatus_component (CORBA_Object _dice_corba_obj,
                       int pdid,
                       int mystatus,
                       CORBA_Server_Environment *_dice_corba_env)
{
    int res = -2;
   
    if(!(pdid>=0 && mystatus>0 && mystatus <4 && pds_map[pdid]))
    {
        return -L4_EINVAL;
    }


    /* If RUNNING is required */
    if(mystatus==RUNNING)
    {
        /* Start the task */
    
        LOGd(dbgbmi,"(bmi) setStatus pdid(%d) -> 1 START\n",pdid);
    
        startPD_intern(pdid);

        LOGd(dbgbmi,"(bmi) setStatus pdid(%d) -> 1 END bmilx(%u.%u)\n",pdid,
            (pds_map[pdid]->bmilx).id.task, 
            (pds_map[pdid]->bmilx).id.lthread); 
    }


    /* If SHUTDOWN is required */

    if(mystatus==SHUTDOWN)
    {
        /* Check that the PD is running (the bmilx has been registered)*/
        LOGd(dbgbmi,"(bmi): setStatus PD(%d) -> 2 START\n",pdid);


        if(l4_is_invalid_id(pds_map[pdid]->bmilx))
        {
            LOGd(dbgbmi,"(bmi): BMILX for PD(%d) not registered yet !\n",pdid);
            return 1;
        }

        else
        {
            LOGd(dbgbmi,"(bmi) BMILX for PD(%d) indeed registered as %u.%u.\n",
                 pdid,
                 (pds_map[pdid]->bmilx).id.task, 
                 (pds_map[pdid]->bmilx).id.lthread);

            /* Ask the bmilx to shutdown softly */
            DICE_DECLARE_ENV(env);
            LOGd(dbgbmi,"(bmi): START shutdown bmilx \n");

            bmilx_shutdownPD_send(&(pds_map[pdid]->bmilx),&env);
            LOGd(dbgbmi,"(bmi): END shutdown via bmilx \n");

            /* Set status of PDEntry to "SHUTDOWN" (2) */
            //        if(!sdownres)
            {
                pds_map[pdid]->status = SHUTDOWN;
                return 0;
            }
            //    else
            //           return 1;
        }

    }

    return res;
}

int
bmi_initPD_component (CORBA_Object _dice_corba_obj,
                      int mymem,
                      int mycpu,
                      int myperformance,
                      int mysize,
                      const char* mydata,
                      CORBA_Server_Environment *_dice_corba_env)
{
    LOGd(dbgbmi,"(bmi): Starting initialization...\n");

    /* If called from PDManagement::allocatePD, only desc is provided (3 first params) */
    if(mymem && mycpu && myperformance)
    {
        PDDesc desc;
        desc.mem = mymem;
        desc.cpu = mycpu;
        desc.performance = myperformance;

        /* Compute a new PDEntry for the new PD
         * */
        PDEntry* newel = new PDEntry;
        newel->pddesc = desc;
        newel->prio = BMI_DEFAULT_PRIORITY;
        newel->status = BMI_DEFAULT_STATUS;
    
        /* Register the new PDEntry and return the pdid
         * */
        int place = -2;
        place = registerPD(newel, pds_map);

        newel->pdid = place;
    
        LOGd(dbgbmi,"(bmi): Initialization for PD(%d) succeeded!\n",place);

        return place;
    }

    else
    {
        LOG("(bmi): Initialization failed!\n");
        return -L4_EINVAL;
    }
}




int
bmi_setImage_component (CORBA_Object _dice_corba_obj,
                        int pdid,
                        int imgsize,
                        const char* data,
                        CORBA_Server_Environment *_dice_corba_env)
{
    
    LOG("(bmi)####################  data:(%s)\n",data);
    
    int res = -L4_EINVAL;
    if(pdid>=0 && pdid<MAX_PDS && pds_map[pdid]!=NULL)
    {
        pds_map[pdid]->size = imgsize;
        strcpy(pds_map[pdid]->data,data);
        res = 0;

        /* Check whether it is a L4Linux task. */
        //cmdline[num_bytes-1] = 0;
        char *pos = strstr(data,"l4linux-");
        if(pos!=NULL)
            pds_map[pdid]->isl4lx=1;

        else
            pds_map[pdid]->isl4lx=0;
    }

    return res;
}


int 
bmi_setAllowedCon_component(CORBA_Object _dice_corba_obj,
                            int pdid,
                            int tid, 
                            int con_map,
                            int disable_existing,
                            CORBA_Server_Environment *_dice_corba_env)
{
    int res = -L4_EINVAL;
    if(pdid>=0 && pdid<MAX_PDS && pds_map[pdid]!=NULL)
    {
        /* The whole conlist is empty, create the first entry */
        if(pds_map[pdid]->conlist==NULL)
        {
            pds_map[pdid]->conlist = new PDPolicy(tid,con_map);
            return 0;    
        }

        else
        {
            PDPolicy* tmp = pds_map[pdid]->conlist;

            if(tmp->dest==tid)
            {
                if(disable_existing)
                    tmp->conmap = 0;

                tmp->conmap |= con_map;
                return 0;
            }

            while(tmp->next)
            {
                if(tmp->next->dest==tid)
                {
                    if(disable_existing)
                        tmp->next->conmap = 0;
                    
                    tmp->next->conmap |= con_map;
                    return 0;
                }
                tmp = tmp->next;
            }
            
            tmp->next = new PDPolicy(tid,con_map);
            
            return 0;
        }
    }
    return res;
}

int 
bmi_getAllowedCon_component(CORBA_Object _dice_corba_obj,
                            int pdid,
                            int tid, 
                            int* conmap,
                            CORBA_Server_Environment *_dice_corba_env)
{
    int res = -L4_EINVAL;
    if(pdid>=0 && pdid<MAX_PDS && pds_map[pdid]!=NULL)
    { 
        PDPolicy* tmp = pds_map[pdid]->conlist;
    
        while(tmp)
        {
            /* If the PDPolicy for this tid is found, get the map */
            if(tmp->dest==tid)
            {
                *conmap = tmp->conmap;
                return 0;
            }

            tmp = tmp->next;
        }
        res = 0;
    }
    return res;
}

int 
bmi_listAllPD_component(CORBA_Object _dice_corba_obj,
                        int* pdslist[],
                        int* listlength,
                        CORBA_Server_Environment *_dice_corba_env)
{
    LOGd(dbgbmi,"(bmi) >>> Start list PDs\n");

    static int listbuf[MAX_PDS];
    int i;
    int j = 0;

    for (i = 0; i < MAX_PDS; i++) {
        if (pds_map[i] != NULL) {
            LOGd(dbgbmi,"(bmi) add List entry(%d) for pds_map[%d]\n",j,i);
            listbuf[j] = i;   // add PDID to list
            j++;              // increase array index
        }
    }

    *pdslist    = listbuf;
    *listlength = j;

    LOGd(dbgbmi,"(bmi) >>> End list PDs\n");

    return 0;
}

int 
bmi_listAllflags_component(CORBA_Object _dice_corba_obj,
                        int* flagslist[],
                        int* listlength,
                        CORBA_Server_Environment *_dice_corba_env)
{
    LOGd(dbgbmi,"(bmi) >>> Start list flags\n");

    static int listbuf[MAX_PDS];
    int i;
    int j = 0;

    for (i = 0; i < MAX_PDS; i++) {
        if (pds_map[i] != NULL) {
            LOGd(dbgbmi,"(bmi) add List flags entry(%d) for pds_map[%d]\n",j,i);
            listbuf[j] = pds_map[i]->isl4lx;   // add PDID to list
            j++;              // increase array index
        }
    }

    *flagslist    = listbuf;
    *listlength = j;

    LOGd(dbgbmi,"(bmi) >>> End list PDs\n");

    return 0;
}


int 
bmi_setMemoryLimits_component(CORBA_Object _dice_corba_obj,
                              int pdid,
                              int min_mem,
                              int max_mem, 
                              CORBA_Server_Environment *_dice_corba_env)
{
    
    int res = -L4_EINVAL;
    if(pdid>=0 && pdid<MAX_PDS && pds_map[pdid]!=NULL)
    {
        if(min_mem>=0)
            pds_map[pdid]->minmem = min_mem;
    
        if(max_mem>=0)
            pds_map[pdid]->maxmem = max_mem;
        
        res = 0;
    }
    
    return res;
}

int 
bmi_setMemoryCurrent_component(CORBA_Object _dice_corba_obj,
                              int pdid,
                              int current_mem,
                              CORBA_Server_Environment *_dice_corba_env)
{
    
    int res = -L4_EINVAL;
    if(pdid>=0 && pdid<MAX_PDS && pds_map[pdid]!=NULL)
    {
        if(current_mem>=0)
            (pds_map[pdid]->pddesc).mem = current_mem;
        res = 0;
    }
    return res;
}

int 
bmi_getMemoryLimits_component(CORBA_Object _dice_corba_obj,
                              int pdid,
                              int* min_mem,
                              int* max_mem, 
                              CORBA_Server_Environment *_dice_corba_env)
{
    int res = -L4_EINVAL;
    if(pdid>=0 && pdid<MAX_PDS && pds_map[pdid]!=NULL)
    {
        *min_mem = *max_mem = -1;

        if(pds_map[pdid]->minmem>=0)
            *min_mem = pds_map[pdid]->minmem;

        if(pds_map[pdid]->maxmem>=0)
            *max_mem = pds_map[pdid]->maxmem;
    
        res = 0;
    }

    return res;
}

int 
bmi_getMemoryCurrent_component(CORBA_Object _dice_corba_obj,
                              int pdid,
                              int* current_mem,
                              CORBA_Server_Environment *_dice_corba_env)
{
    int res = -L4_EINVAL;
    if(pdid>=0 && pdid<MAX_PDS && pds_map[pdid]!=NULL)
    {
        *current_mem = -1;

        if((pds_map[pdid]->pddesc).mem>=0)
            *current_mem = (pds_map[pdid]->pddesc).mem;
    
        res = 0;
    }

    return res;
}


}

int main(int argc, char **argv)
{

    bmi_server_loop(0);
  
    return 0;
}

