#ifndef __BMI_LOCAL_H
#define __BMI_LOCAL_H

#include<l4/cbbmi/bmi_types.h>
#include<l4/cbbmi/bmi.h>

extern l4_threadid_t bmilx_global;

class PDPolicy {

public:
    int dest;
    int conmap;
    PDPolicy* next;

public:
    PDPolicy(int,int);

};


struct PDDesc_struct {
    
    int mem; /* amount of requested memory in bytes */
    int cpu; /* number of requested cpus */
    int performance; /* indicator about the "share" of the cpus the PD will get */

};

typedef PDDesc_struct PDDesc;

class PDEntry 
{
        public:
                int pdid;
                char* pdname;
                l4_threadid_t l4id;
                l4_threadid_t bmilx;
                PDDesc pddesc;
                int prio;
                PDStatus status;
                l4dm_dataspace_t *ds;
                PDImage* img;
                PDStatus status_caps[4]; 
                int size;
                char data[2048];
                PDPolicy* conlist;
                int minmem;
                int maxmem;
                int mincpu;
                int maxcpu;
                int isl4lx;

        public:
                PDEntry(l4_threadid_t id);
                PDEntry();
};



void id_display(l4_threadid_t id);
int registerPD(PDEntry* ent, PDEntry* pds_map[]);


#endif 
