#include<vector>

#include<l4/cbbmi/bmi_types.h>
#include<l4/cbbmi/bmi_classes.h>
#include<l4/names/libnames.h>
#include<l4/cbbmi/bmi.h>

#include "bmi-client.h"

int PDManagement::hasCon(int id)
{
    int k=0;
    while(k<MAX_PDS)
    {
        if(this->pdcons_map[k] && this->pdcons_map[k]->get_pdid()==id)
        {
            return 1;
        }
        k++;
    }

    return 0;
}


PDController* PDManagement::getCon(int id)
{
    int k=0;
    while(k<MAX_PDS)
    {
        if(this->pdcons_map[k] && this->pdcons_map[k]->get_pdid()==id)
        {
            LOGd(dbgpdman,"(pdman) pdcon(%d) found locally at place(%d)\n",
                 this->pdcons_map[k]->get_pdid(),
                 k);

            return this->pdcons_map[k];
        }

        k++;
    }

    LOGd(dbgpdman,"(pdman) pdcon(%d) not found locally!\n",id);
    
    return NULL;
}

void PDManagement::printCons()
{


    LOG("(pdman) >>> START list pdcons\n");
    
    int k=0;
    while(k<MAX_PDS)
    {
        if(this->pdcons_map[k])
            LOG("(pdman) >>> pdcon(%d): pdid(%d)\n",k,this->pdcons_map[k]->get_pdid());

        k++;
    }

    LOG("(pdman) >>> END list pdcons\n");
    return;
}


int PDManagement::addCon(PDController* pdcon)
{
    int k=0;
    while(k<MAX_PDS)
    {
        if(!this->pdcons_map[k])
        {
            this->pdcons_map[k] = pdcon;
            return 0;
        }
        k++;
    }

    LOG("(pdman) pdcons_map is FULL!\n");

    return -1;
}


/* List all the pdids registered at the BMI server */
int* PDManagement::listPD()
{

    LOGd(dbgpdman,"(pdman) >>> START list pdids\n");

    /* Find the bmi server */
    DICE_DECLARE_ENV(env);
    l4_threadid_t id_cbbmi = get_bmi_id();

    int *pdslist = new int[MAX_PDS];
   
    int n=0;
    for(n=0; n<MAX_PDS; n++)
        pdslist[n] = -1;

   
    int length;

    int res = bmi_listAllPD_call(&id_cbbmi,
                                 &pdslist,
                                 &length,
                                 &env);
 

    LOGd(dbgpdman,"(pdman) >>> END list pdids\n");

    return pdslist;
}
    
/* List all the pdids flags which show whether the PD is a L4Linux task. */
int* PDManagement::listflags()
{

    LOGd(dbgpdman,"(pdman) >>> START list flags\n");

    /* Find the bmi server */
    DICE_DECLARE_ENV(env);
    l4_threadid_t id_cbbmi = get_bmi_id();

    int *flagslist = new int[MAX_PDS];
   
    int n=0;
    for(n=0; n<MAX_PDS; n++)
        flagslist[n] = -1;

   
    int length;

    int res = bmi_listAllflags_call(&id_cbbmi,
                                 &flagslist,
                                 &length,
                                 &env);
 

    LOGd(dbgpdman,"(pdman) >>> END list flags\n");

    return flagslist;
}


/* Return the version number of the BMI */ 
int PDManagement::getVersion()
{
    
    /* Find the bmi server. */
    DICE_DECLARE_ENV(env);
    l4_threadid_t id_cbbmi = get_bmi_id();
    
    /* Ask the version at the BMI. */  
    int version;
    int res = bmi_getVersion_call(&id_cbbmi, &version, &env);

    return version;

}

/* Allocate a new PD and return a pointer on the corresponding PDController */ 
PDController* PDManagement::allocatePD(PDDescription desc)
{
    
    /* Find the BMI */
    DICE_DECLARE_ENV(env);
    l4_threadid_t id_cbbmi = get_bmi_id();
    
    /* Ask the BMI to initialize a PD. The PD will be registered at pdids_map[place] */ 
    int place = -2;
    place = bmi_initPD_call(&id_cbbmi, 
                             desc.mem, 
                             desc.cpu, 
                             desc.performance, 
                             NULL,
                             NULL,
                             &env);
   
    /* Create the PDController for this PD */ 
    PDController* pdcon = new PDController(place);
    pdcon->set_pdid(place);
    pdcon->set_desc(desc);

    /* Register locally the PDController */
    LOGd(dbgpdman,"(pdman) Registering locally PD(%d)...\n",place);
    int addres = this->addCon(pdcon);
    LOGd(dbgpdman,"(pdman) PD(%d) locally registered.\n",place);

    /* If the PDController registration failed, return NULL. */
    if(addres)
        return NULL;

    return pdcon;
}

PDController* PDManagement::getController(int pdid)
{

    if(!(pdid<MAX_PDS))
    {
        return NULL;
    }

    /* Check whether a PDController has already been created for this pdid */
    if(this->getCon(pdid)!=NULL)
    {
        return this->getCon(pdid);
    }

    /* If no PDController available, check whether this pdid is registered at the BMI */
    
    /* Find the bmi server */
    DICE_DECLARE_ENV(env);
    l4_threadid_t id_cbbmi = get_bmi_id();
    
    /* Ask the bmi server for this pdid */
    /* If this pdid is not registered at the BMI, return NULL. */
    int hasid = 0;
    int resid = bmi_hasPDID_call(&id_cbbmi, pdid, &hasid, &env);

    if(!hasid)
    {
        return NULL;
    }

    /* Otherwise create a new PDController for this pdid. */
    PDController* pdcon = new PDController(pdid);
    int addres = addCon(pdcon);
        
    /* If the PDController registration failed, return NULL. */
    if(addres)
    {
        return NULL;
    }

    return pdcon;
   
}


PDController* PDManagement::getController()
{
    
    DICE_DECLARE_ENV(env);
    l4_threadid_t id_cbbmi = get_bmi_id();

    /* Check if I am registered at the bmi server */ 
    const l4_threadid_t my_threadid = l4_myself();

    int pdid = -2;

    int res = -2;
    res = bmi_lookupPDID_call(&id_cbbmi, &my_threadid, &pdid, &env);

    if(res)
    {
        LOG("(pdman): calling thread not registered as PD at the bmi!\n");
        return NULL;
    }
    
    if(pdid>=0 && pdid<MAX_PDS && this->pdcons_map[pdid]!=NULL)
    {
        return this->getCon(pdid);
    }

    return NULL;
}


