#ifndef __BMI_H_
#define __BMI_H_

#include<l4/cbbmi/bmi_types.h>
#include<l4/cbbmi/bmi_classes.h>
#include<l4/cbbmi/bmi_logs.h>

#include<l4/names/libnames.h>


#include<l4/log/l4log.h>
#include<l4/env/errno.h>
#include "bmi-client.h"


#define BMI_DEFAULT_PRIORITY 7
#define BMI_DEFAULT_STATUS SHUTDOWN
#define MAX_IMAGE_DATA_LENGTH 100
#define MAX_CMDLINE_LENGTH 500
static const unsigned int bmi_major_version = 0;
static const unsigned int bmi_minor_version = 1;


static inline l4_threadid_t get_bmi_id()
{
    /* Find the bmi server */
    l4_threadid_t id_cbbmi = L4_INVALID_ID;
    if(!names_waitfor_name("cbbmi.main",&id_cbbmi,3000))
    {
        LOG("(get_bmi_id) cbbmi.main not found!\n");
    }

    return id_cbbmi;
}
 
#endif 
