#include <stdio.h>
#include<vector>
#include<string>


#include<l4/dm_mem/dm_mem.h>
#include<l4/names/libnames.h>

#include<l4/dm_generic/dm_generic.h>
#include<l4/util/util.h>


#include<l4/cbbmi/bmi_classes.h>
#include<l4/cbbmi/bmi.h>

/* Command line pattern: 
 * 
 * ./bmi --start image_name mem_size
 * ./bmi --shutdown pdid
 * ./bmi --destroy pdid
 *
 */


/* Print information about the PDs currently registered at the BMI, 
 * and check whether a PDController is already locally available for it.. */
void printAllPDs(PDManagement* pdman, int* listpds, char* type)
{
    l4_threadid_t me = l4_myself();
    LOG("(exo)[%u.%u] ***** LIST %s start from exo *****\n",
        me.id.task, me.id.lthread,
        type);
    int k=0;
    while(k<MAX_PDS)
    {
        if(listpds[k]!=-1)
        {
            if(pdman->hasCon(k))
                LOG("(exo) list[%d]: %d -> YES\n",k,listpds[k]);
            else
                LOG("(exo) list[%d]: %d -> NO\n",k,listpds[k]);
        }
        k++;
    }
    LOG("(exo)[%u.%u] ***** LIST %s stop from exo *****\n",
        me.id.task, me.id.lthread,type);
}

/* Print more information about the PDs currently registered at the BMI, 
 * and check whether a PDController is already locally available for it.. */
void printAllPDs_islx(PDManagement* pdman, int* listpds, int* listflags, int showcon, int nb, char* type)
{
    l4_threadid_t me = l4_myself();
    if(!showcon)
        LOG("(exo) ***** LIST [%d] of available PDs *****\n",nb);
    
    else
        LOG("(exo)[%u.%u] ***** LIST %s [%d] start from exo *****\n",
        me.id.task, me.id.lthread,
        type,
        nb);
    
    int k=0;
    while(k<MAX_PDS)
    {
        if(listpds[k]!=-1)
        {
            int hascon = 0;
           
            if(pdman->hasCon(k))
                hascon = 1;

            if(!showcon)
                LOG("(exo) list[%d]: PD(%d) - is_L4Linux(%d)\n",
                k, 
                listpds[k], 
                listflags[k]);
                
            else
                LOG("(exo) list[%d]: PD(%d) - hasCon(%d) - islx(%d)\n",
                k, 
                listpds[k], 
                hascon, 
                listflags[k]);
        }
        k++;
    }

    if(!showcon)
        LOG("(exo) ***** LIST [%d] end *****\n",nb);
        
    else
        LOG("(exo)[%u.%u] ***** LIST %s [%d] stop from exo *****\n",
            me.id.task, me.id.lthread,type,nb);
}


int main(int argc, char** argv)
{
    LOGd(dbgexo,"(exo): START!\n");

    /* Get the required action (1st command line argument) */
    if(argc>1)
    {
        char* cmd1 = argv[1];

        /* Create the PDManagement */
        PDManagement* pdman = new PDManagement;


        /* START a PD 
       
         * 1. Create and allocate the PD:
         ***** a. Create a PDDescription 
         ***** b. Create and allocate a pdcontroller 
         ***** c. Create a PDImage
         ***** d. Setup the PD. Initially it has status SHUTDOWN

         * 2. Start the PD: requestStatusChange(RUNNING).
         ***** a. Call to the BMI server
         ***** b. BMI checks that this pdid is registered
         ***** c. BMI asks loader to start a new task
         ***** d. BMI updates infos for this PD (status, l4id)

         */
        
        if( (!strcmp(cmd1,"--start")) || (!strcmp(cmd1,"--start-linux")) )
        {
            /* Get the name of the binary (2d command line argument) */
            if(argc>2)
            {
                char* cmd2 = argv[2];

                /* Check whether the binary name was registered. */
                /* Create the PDDescription with default values */
                    PDDescription desc;
                    desc.mem = 32;
                    desc.cpu = 1;
                    desc.performance = 1;

                    /* Create the PDImage with default values */
                    PDImage* img = new PDImage(desc.mem,cmd2);
                    
                                       
                    /* If the task is a L4Linux, make the required modifications */ 
                    if (!strcmp(cmd1,"--start-linux"))
                    {

                        LOGd(dbgexo,"(exo) Modifying params for (%s)\n",cmd2);

                        /* Check if the memory size is provided (3rd command line argument). 
                         * and modify default value if necessary. */
                        if(argc>3)
                        {
                            char* cmd3 = argv[3];
                            desc.mem = atoi(cmd3);
                        }
                   
                       /* Modify the binary image <img>: 
                        * *** - if the task is a L4Linux, transform into:
                        * ***   "l4linux-<img>"
                        * *** - if it is another task, transform into:
                        * ***   "<img>#args#, where "args" are the command line arguments given for this task (if any)   
                        */

                        char strnew[MAX_IMAGE_DATA_LENGTH];
                        char* strlx = "l4linux-";

                        int i=0;
                        for(i=0;i<8;i++)
                        {
                            strnew[i] = strlx[i];
                        }

                        i=0;
                        while(cmd2[i]!='\0')
                        {
                            strnew[i+8] = cmd2[i];
                            i++;
                        }
                        strnew[i+8] = '\0';

                        img->set_data(strnew);

                        LOGd(dbgexo,"(exo) new params for (%s): mem(%d) data(%s)\n",
                             cmd2,
                             desc.mem,
                             strnew);

                    }
                    else
                    {
                        /* Modify the binary image <img>: 
                        * *** - if the task is a L4Linux, transform into:
                        * ***   "l4linux-<img>"
                        * *** - if it is another task, transform into:
                        * ***   "<img>$arg1$arg2$arg3#, where the "argN"s are the command line arguments given for this task (if any)   
                        */

                        /* Check if other command line arguments are given and store them. */
                        char newcmd[MAX_CMDLINE_LENGTH];
                        
                        /* First copy the name of the task.*/
                        int j=0;
                        while(cmd2[j]!='\0')
                        {
                            newcmd[j] = cmd2[j];
                            j++;
                        }

                        newcmd[j] = '$';
                        j++;

                        /* Then encode in the string the additional cmdline parameters. */
                        int i=3;
                        char* arg;
                        while(i<argc)
                        {
                            arg = argv[i];
                            LOG("(exo): ARGV[%d] is (%s)\n",i,arg);
                            int n=0;
                            while(arg[n]!='\0')
                            {
                                newcmd[j] = arg[n];
                                n++;
                                j++;
                            }
                            newcmd[j++] = ' ';
                            LOG("(exo) argv[%d] NEWCMD(%s)\n",i,newcmd);
                            i++;
                        }
                        newcmd[j] = '\0';
                        img->set_data(newcmd);

                    }
#if 0
                        if(argc>3)
                        {
                            char* cmd3 = argv[3];
                            desc.mem = atoi(cmd3);
                        }
                        char strnew[MAX_IMAGE_DATA_LENGTH];
                        char* strlx = "l4linux-";

                        int i=0;
                        for(i=0;i<8;i++)
                        {
                            strnew[i] = strlx[i];
                        }

                        i=0;
                        while(cmd2[i]!='\0')
                        {
                            strnew[i+8] = cmd2[i];
                            i++;
                        }
                        strnew[i+8] = '\0';

                        img->set_data(strnew);

                        LOGd(dbgexo,"(exo) new params for (%s): mem(%d) data(%s)\n",
                             cmd2,
                             desc.mem,
                             strnew);

#endif 

                    LOGd(dbgexo,"(exo) Creating PD(%s)...\n",cmd2);

                    PDController* pdcon0 = pdman->allocatePD(desc);
                    //PDController* pdcon1 = pdman->allocatePD(desc);

                    //PDImage* img = new PDImage(mem,cmd2);

                    pdcon0->setupPD(img);
                    //pdcon1->setupPD(img);

                    LOGd(dbgexo,"(exo) Created PD 0(%s,%d) with pdid(%d),status(%d).\n",
                         cmd2,
                         desc.mem,
                         pdcon0->getPDID(),
                         pdcon0->getCurrentStatus());
#if 0
                    LOGd(dbgexo,"(exo) Created PD 1(%s,%d) with pdid(%d),status(%d).\n",
                             cmd2,
                             mem,
                             pdcon1->getPDID(),
                             pdcon1->getCurrentStatus());
#endif            
                    l4_sleep(2000);

                    /* START the PD 0 */
                    LOGd(dbgexo,"(exo) Starting PD 0(%d)... \n",pdcon0->getPDID());
                    
                    pdcon0->requestStatusChange(RUNNING);
                    LOGd(dbgexo,"(exo) Started PD 0(%d), status=%d.\n",
                         pdcon0->getPDID(),
                         pdcon0->getCurrentStatus());
                    
            //        l4_sleep(10000);
#if 0
                    /* START the PD 1 */
                    LOGd(dbgexo,"(exo) Starting PD 1(%d)... \n",pdcon1->getPDID());
                    pdcon1->requestStatusChange(RUNNING);
                    LOGd(dbgexo,"(exo) Started PD 1(%d), status=%d.\n",
                         pdcon1->getPDID(),
                         pdcon1->getCurrentStatus());

                    l4_sleep(10000);
#endif 

                    l4_sleep(10000); 
                    if(dbgexo)
                    {
                        int* listpds = pdman->listPD();
                        int* listflags = pdman->listflags();
                        //printAllPDs(pdman,listpds,"START");
                        printAllPDs_islx(pdman,listpds,listflags,1,-2,"START");
                    }
	    }
	}

  
        /* SHUTDOWN a PD 
       
         * 1. Retrieve the pdid of the PD to shut down from the command line.
         * 2. Get the PDController for this PD.
         * 3. Shut down the PD: requestStatusChange(SHUTDOWN)
         ***** a. Call to the BMI server
         ***** b. BMI checks that this bmilx has been registered for this PD
         ***** c. BMI asks bmilx to shutdown the PD
         ***** d. BMI updates status for this PD to SHUTDOWN

         */
        
        else if (!strcmp(cmd1,"--shutdown"))
        {
            /* Get the pdid (2d command line argument).*/
            int pdid = -1;
            if(argc>2)
            {
                char* cmd2 = argv[2];
                pdid = atoi(cmd2);
                LOGd(dbgexo,"(exo): Shutting down PD(%d)...\n",pdid);
            }
            
            /* Get the PDController for this PD.  */
            int i=0;
            while(i<20)
            {
                if(!(pdman->getController(pdid)))
                {
                    LOG("(exo): [%d] Impossible to shutdown PD(%d): not registered yet.\n",i,pdid);
                }

                else
                {
                    LOGd(dbgexo,"(exo): [%d] OK to shutdown PD(%d): registered.\n",i,pdid);
                    break;
                }
               
                l4_sleep(1000);
                i++;
            }

            if(i==20)
            {
                LOG("(exo) Impossible to shutdown PD(%d). ABORTED!\n",pdid);
                
                l4_sleep(10000); 
                if(dbgexo)
                {
                    int* listpds = pdman->listPD();
                    int* listflags = pdman->listflags();
                    //printAllPDs(pdman,listpds,"START");
                    printAllPDs_islx(pdman,listpds,listflags,1,-2,"SHUTDOWN");
        
                    //int* listpds = pdman->listPD();
                    //printAllPDs(pdman,listpds,"SHUTDOWN");
                }
                return 1;
            }

            PDController *pdcon = pdman->getController(pdid);
            PDStatus stat1 = pdcon->getCurrentStatus();
            LOGd(dbgexo,"(exo) Current Status (%d) BEFORE shutdown.\n",stat1);

            LOGd(dbgexo,"(exo) SHUTTING DOWN (%d)\n",pdid);
            pdcon->requestStatusChange(SHUTDOWN);
            stat1 = pdcon->getCurrentStatus();
            LOGd(dbgexo,"(exo) Current Status (%d) AFTER shutdown\n",stat1);
            
            l4_sleep(10000); 
            if(dbgexo)
            {
                int* listpds = pdman->listPD();
                int* listflags = pdman->listflags();
                //printAllPDs(pdman,listpds,"START");
                printAllPDs_islx(pdman,listpds,listflags,1,-2,"SHUTDOWN");
            }
        }

        /* DESTROY a PD 
       
         * 1. Retrieve the pdid of the PD to destroy from the command line.
         * 2. Get the PDController for this PD.
         * 3. Destroy the PD: pdcon->destroy()
         ***** a. Ask the BMI for the l4_thread_id of the PD task.
         ***** b. Ask the BMI to kill the PD
         ********** i. Kill the PD task
         ********** ii. Deregister this PD (remove all infos about it)
         
         */
        
        else if (!strcmp(cmd1,"--destroy"))
        {
            /* Get the pdid (2d command line argument).*/
            int pdid = -1;
            if(argc>2)
            {
                char* cmd2 = argv[2];
                pdid = atoi(cmd2);
                LOGd(dbgexo,"(exo): Destroying PD(%d)...\n",pdid);
            }
            
            /* Get the PDController for this PD.  */
            int i=0;
            while(i<20)
            {
                if(!(pdman->getController(pdid)))
                {
                    LOG("(exo): [%d] Impossible to destroy PD(%d): not registered yet.\n",i,pdid);
                }

                else
                {
                    LOGd(dbgexo,"(exo): [%d] OK to destroy PD(%d): registered.\n",i,pdid);
                    break;
                }
               
                l4_sleep(1000);
                i++;
            }

            if(i==20)
            {
                LOG("(exo) Impossible to destroy PD(%d). ABORTED!\n",pdid);
                l4_sleep(10000); 
                if(dbgexo)
                {
                    //int* listpds = pdman->listPD();
                    //printAllPDs(pdman,listpds,"DESTROY");
                    int* listpds = pdman->listPD();
                    int* listflags = pdman->listflags();
                    //printAllPDs(pdman,listpds,"START");
                    printAllPDs_islx(pdman,listpds,listflags,1,-2,"DESTROY");
                }
                return 1;
            }

            PDController *pdcon = pdman->getController(pdid);
            PDStatus stat1 = pdcon->getCurrentStatus();
            LOGd(dbgexo,"(exo) Current Status (%d) BEFORE destruction.\n",stat1);

            LOGd(dbgexo,"(exo) DESTROYING (%d)\n",pdid);
            pdcon->destroy();
            stat1 = pdcon->getCurrentStatus();
            LOGd(dbgexo,"(exo) Current Status (%d) AFTER destruction\n",stat1);
                
            l4_sleep(10000); 
            if(dbgexo)
            {
                //int* listpds = pdman->listPD();
                //printAllPDs(pdman,listpds,"DESTROY");
                int* listpds = pdman->listPD();
                int* listflags = pdman->listflags();
                //printAllPDs(pdman,listpds,"START");
                printAllPDs_islx(pdman,listpds,listflags,1,-2,"DESTOY");
            }

        }

        else if (!strcmp(cmd1,"--listpds"))
        {

            LOGd(dbgexo,"(exo) LISTPDS START\n");
            int* listpds = pdman->listPD();
            int* listflags = pdman->listflags();
            int showcon = 0;
            //printAllPDs(pdman,listpds,"START");
            //printAllPDs_islx(pdman,listpds,listflags,showcon,"DESTOY");


            /* Get the pdid (2d command line argument).*/
            int nb = -1;
            if(argc>2)
            {
                char* cmd2 = argv[2];
                nb = atoi(cmd2);
            }
            
            printAllPDs_islx(pdman,listpds,listflags,showcon,nb,"DESTOY");
#if 0            
            /* Get the PDController for this PD.  */
            int i=0;
            while(i<20)
            {
                if(!(pdman->getController(pdid)))
                {
                    LOG("(exo): [%d] Impossible to destroy PD(%d): not registered yet.\n",i,pdid);
                }

                else
                {
                    LOGd(dbgexo,"(exo): [%d] OK to destroy PD(%d): registered.\n",i,pdid);
                    break;
                }
               
                l4_sleep(1000);
                i++;
            }

            if(i==20)
            {
                LOG("(exo) Impossible to destroy PD(%d). ABORTED!\n",pdid);
                l4_sleep(10000); 
                if(dbgexo)
                {
                    int* listpds = pdman->listPD();
                    printAllPDs(pdman,listpds,"DESTROY");
                }
                return 1;
            }

            PDController *pdcon = pdman->getController(pdid);
            PDStatus stat1 = pdcon->getCurrentStatus();
            LOGd(dbgexo,"(exo) Current Status (%d) BEFORE destruction.\n",stat1);

            LOGd(dbgexo,"(exo) DESTROYING (%d)\n",pdid);
            pdcon->destroy();
            stat1 = pdcon->getCurrentStatus();
            LOGd(dbgexo,"(exo) Current Status (%d) AFTER destruction\n",stat1);
                
            l4_sleep(10000); 
            if(dbgexo)
            {
                int* listpds = pdman->listPD();
                printAllPDs(pdman,listpds,"DESTROY");
            }
            
        
#endif 
	}
        else
	  LOG("invalid parameter %s\n",cmd1);

    }


    return 0;

}
 
