INTERFACE [debug]:

EXTENSION class Kip
{
private:
  void debug_print_syscalls() const;
};

IMPLEMENTATION [debug]:


#include <cstdio>
#include <cstring>
#include "simpleio.h"

static char const *const memory_desc_types[] = {
    "Undefined",
    "Conventional",
    "Reserved",
    "Dedicated",
    "Shared",
    "(undef)",
    "(undef)",
    "(undef)",
    "(undef)",
    "(undef)",
    "(undef)",
    "(undef)",
    "(undef)",
    "(undef)",
    "Bootloader",
    "Arch" };

PUBLIC
void 
Mem_desc::dump() const
{
  printf("%s [%016lx-%016lx] %s", is_virtual()?"virt":"phys",
      start(), end() + 1, memory_desc_types[type()]);
}

PRIVATE
void
Kip::debug_print_memory() const
{
  printf("Memory (max %d descriptors):\n",num_mem_descs());
  Mem_desc const *m = mem_descs();
  Mem_desc const *const e = m + num_mem_descs();
  for (;m<e;++m)
    {
      if (m->type() != Mem_desc::Undefined)
	{
	  printf(" %2d:", (int)(m - mem_descs() + 1));
	  m->dump();
	  puts("");
	}
    }
}

PRIVATE
void
Kip::debug_print_features() const
{
  printf("Kernel features:");
  char const *f = version_string();
  for (f += strlen(f) + 1; *f; f += strlen(f) + 1)
    {
      putchar(' ');
      putstr(f);
    }
  putchar('\n');
}


IMPLEMENT
void Kip::print() const
{
  printf("KIP @ %p\n", this);
  printf("magic: %.4s  version: 0x%lx\n",(char*)&magic, version);
  printf("clock: " L4_X64_FMT " (%lld)\n", clock, clock);
  printf("freq_cpu: %ldkHz\n", frequency_cpu);
  printf("freq_bus: %ldkHz\n", frequency_bus);

  printf("sigma0_ip: "L4_PTR_FMT" sigma0_sp: "L4_PTR_FMT"\n", sigma0_ip, sigma0_sp);
  printf("sigma1_ip: "L4_PTR_FMT" sigma1_sp: "L4_PTR_FMT"\n", sigma1_ip, sigma1_sp);
  printf("root_ip:   "L4_PTR_FMT" root_sp:   "L4_PTR_FMT"\n", root_ip,   root_sp);
  debug_print_memory();
  debug_print_syscalls();
  debug_print_features();

  printf("user_ptr: %p\n", (void*)user_ptr);

}
