/**
 * \file   l4vfs/term_server/lib/vt100/keymap.c
 * \brief  
 *
 * \date   2006-03-08
 * \author Martin Pohlack  <mp26@os.inf.tu-dresden.de>
 */
/* (c) 2006 Technische Universitaet Dresden
 * This file is part of DROPS, which is distributed under the terms of the
 * GNU General Public License 2. Please see the COPYING file for details.
 */

#include "keymap.h"

/*********************************************************************
 *
 *  us
 *
 *********************************************************************/

keymap_t vt100_keymap_us =
{
    {"",         ""},        // 0
    {"\033",     "\033"},        // 1 - ESC
    {"1",        "!"},       // 2
    {"2",        "@"},
    {"3",        "#"},
    {"4",        "$"},
    {"5",        "%"},
    {"6",        "^"},
    {"7",        "&"},
    {"8",        "*"},
    {"9",        "("},
    {"0",        ")"},
    {"-",        "_"},
    {"=",        "+"},
    {"\b",       "\b"},      // 14 - Backspace
    {"\t",       "\t"},      // 15
    {"q",        "Q"},
    {"w",        "W"},
    {"e",        "E"},
    {"r",        "R"},
    {"t",        "T"},
    {"y",        "Y"},
    {"u",        "U"},
    {"i",        "I"},
    {"o",        "O"},
    {"p",        "P"},
    {"[",        "{"},
    {"]",        "}"},       // 27
    {"\r",       "\r"},      // 28 - Enter
    {"",         ""},        // 29 - Ctrl
    {"a",        "A"},       // 30
    {"s",        "S"},
    {"d",        "D"},
    {"f",        "F"},
    {"g",        "G"},
    {"h",        "H"},
    {"j",        "J"},
    {"k",        "K"},
    {"l",        "L"},
    {";",        ":"},
    {"'",        "\""},      // 40
    {"`",        "~"},       // 41
    {"",         ""},        // 42 - Left Shift
    {"\\",       "|"},       // 43
    {"z",        "Z"},       // 44
    {"x",        "X"},
    {"c",        "C"},
    {"v",        "V"},
    {"b",        "B"},
    {"n",        "N"},
    {"m",        "M"},
    {",",        "<"},
    {".",        ">"},
    {"/",        "?"},       // 53
    {"",         ""},        // 54 - Right Shift
    {"*",        "*"},       // 55 - Numeric keypad '*'
    {"",         ""},        // 56 - Alt
    {" ",        " "},       // 57 - Space bar
    {"",         ""},        // 58 - Caps Lock
    {"\033OP",   ""},        // 59 - F1
    {"\033OQ",   ""},        // 60 - F2
    {"\033OR",   ""},        // 61 - F3
    {"\033OS",   ""},        // 62 - F4
    {"\033[15~", ""},        // 63 - F5
    {"\033[17~", ""},        // 64 - F6
    {"\033[18~", ""},        // 65 - F7
    {"\033[19~", ""},        // 66 - F8
    {"\033[20~", ""},        // 67 - F9
    {"\033[21~", ""},        // 68 - F10
    {"",         ""},        // 69 - Num Lock
    {"",         ""},        // 70 - Scroll Lock
    {"7",        "7"},       // 71 - Numeric keypad 7
    {"8",        "8"},       // 72 - Numeric keypad 8
    {"9",        "9"},       // 73 - Numeric keypad 9
    {"-",        "-"},       // 74 - Numeric keypad '-'
    {"4",        "4"},       // 75 - Numeric keypad 4
    {"5",        "5"},       // 76 - Numeric keypad 5
    {"6",        "6"},       // 77 - Numeric keypad 6
    {"+",        "+"},       // 78 - Numeric keypad '+'
    {"1",        "1"},       // 79 - Numeric keypad 1
    {"2",        "2"},       // 80 - Numeric keypad 2
    {"3",        "3"},       // 81 - Numeric keypad 3
    {"0",        "0"},       // 82 - Numeric keypad 0
    {".",        "."},       // 83 - Numeric keypad '.'
    {"",         ""},
    {"",         ""},
    {"",         ""},
    {"",         ""},
    {"",         ""},
    {"",         ""},
    {"",         ""},
    {"",         ""},
    {"",         ""},
    {"",         ""},
    {"",         ""},
    {"",         ""},
    {"\r",       "\r"},      // 96 - Numeric keypad Enter
    {"",         ""},
    {"/",        "/"},       // 98 - Numeric keypad '/'
    {"",         ""},
    {"",         ""},        // 100 - AltGr
    {"",         ""},
    {"\033[H",   ""},        // 102 - Home
    {"\033[A",   ""},        // 103 - arrow up
    {"\033[5~",  ""},        // 104 - PgUp
    {"\033[D",   ""},        // 105 - arrow left
    {"\033[C",   ""},        // 106 - arrow right
    {"\033[F",   ""},        // 107 - End
    {"\033[B",   ""},        // 108 - arrow down
    {"\033[5~",  ""},        // 109 - PgDown
    {"\033[2~",  ""},        // 110 - Insert
    {"\033[3~",  ""},        // 111 - Del
    {"",         ""},
    {"",         ""},
    {"",         ""},
    {"",         ""},
    {"",         ""},
    {"",         ""},
    {"",         ""},
    {"\033[P",   ""},        // 119 - Pause
    {"",         ""},
    {"",         ""},
    {"",         ""},
    {"",         ""},
    {"",         ""},
    {"",         ""},
    {"",         ""},
    {"",         ""},
};

/*********************************************************************
 *
 *  de
 *
 *********************************************************************/

keymap_t vt100_keymap_de =
{
    {"",         ""},        // 0
    {"\033",     "\033"},    // 1 - ESC
    {"1",        "!"},       // 2
    {"2",        "\""},
    {"3",        ""},
    {"4",        "$"},
    {"5",        "%"},
    {"6",        "&"},
    {"7",        "/"},
    {"8",        "("},
    {"9",        ")"},
    {"0",        "="},
    {"",        "?"},
    {"'",        "`"},
    {"\b",       "\b"},      // 14 - Backspace
    {"\t",       "\t"},      // 15
    {"q",        "Q"},
    {"w",        "W"},
    {"e",        "E"},
    {"r",        "R"},
    {"t",        "T"},
    {"z",        "Z"},
    {"u",        "U"},
    {"i",        "I"},
    {"o",        "O"},
    {"p",        "P"},
    {"",        ""},
    {"+",        "*"},       // 27
    {"\r",       "\r"},      // 28 - Enter
    {"",         ""},        // 29 - Ctrl
    {"a",        "A"},       // 30
    {"s",        "S"},
    {"d",        "D"},
    {"f",        "F"},
    {"g",        "G"},
    {"h",        "H"},
    {"j",        "J"},
    {"k",        "K"},
    {"l",        "L"},
    {"",        ""},
    {"",        ""},       // 40
    {"^",        ""},       // 41
    {"",         ""},        // 42 - Left Shift
    {"#",        "'"},       // 43
    {"y",        "Y"},       // 44
    {"x",        "X"},
    {"c",        "C"},
    {"v",        "V"},
    {"b",        "B"},
    {"n",        "N"},
    {"m",        "M"},
    {",",        ";"},
    {".",        ":"},
    {"-",        "_"},       // 53
    {"",         ""},        // 54 - Right Shift
    {"*",        "*"},       // 55 - Numeric keypad '*'
    {"",         ""},        // 56 - Alt
    {" ",        " "},       // 57 - Space bar
    {"",         ""},        // 58 - Caps Lock
    {"\033OP",   ""},        // 59 - F1
    {"\033OQ",   ""},        // 60 - F2
    {"\033OR",   ""},        // 61 - F3
    {"\033OS",   ""},        // 62 - F4
    {"\033[15~", ""},        // 63 - F5
    {"\033[17~", ""},        // 64 - F6
    {"\033[18~", ""},        // 65 - F7
    {"\033[19~", ""},        // 66 - F8
    {"\033[20~", ""},        // 67 - F9
    {"\033[21~", ""},        // 68 - F10
    {"",         ""},        // 69 - Num Lock
    {"",         ""},        // 70 - Scroll Lock
    {"7",        "7"},       // 71 - Numeric keypad 7
    {"8",        "8"},       // 72 - Numeric keypad 8
    {"9",        "9"},       // 73 - Numeric keypad 9
    {"-",        "-"},       // 74 - Numeric keypad '-'
    {"4",        "4"},       // 75 - Numeric keypad 4
    {"5",        "5"},       // 76 - Numeric keypad 5
    {"6",        "6"},       // 77 - Numeric keypad 6
    {"+",        "+"},       // 78 - Numeric keypad '+'
    {"1",        "1"},       // 79 - Numeric keypad 1
    {"2",        "2"},       // 80 - Numeric keypad 2
    {"3",        "3"},       // 81 - Numeric keypad 3
    {"0",        "0"},       // 82 - Numeric keypad 0
    {".",        "."},       // 83 - Numeric keypad '.'
    {"",         ""},
    {"",         ""},
    {"<",        ">"},
    {"",         ""},        // 86 - F11
    {"",         ""},        // 87 - F12
    {"",         ""},
    {"",         ""},
    {"",         ""},
    {"",         ""},
    {"",         ""},
    {"",         ""},
    {"",         ""},
    {"\r",       "\r"},      // 96 - Numeric keypad Enter
    {"",         ""},
    {"/",        "/"},       // 98 - Numeric keypad '/'
    {"",         ""},
    {"",         ""},        // 100 - AltGr
    {"",         ""},
    {"\033[H",   ""},        // 102 - Home
    {"\033[A",   ""},        // 103 - arrow up
    {"\033[5~",  ""},        // 104 - PgUp
    {"\033[D",   ""},        // 105 - arrow left
    {"\033[C",   ""},        // 106 - arrow right
    {"\033[F",   ""},        // 107 - End
    {"\033[B",   ""},        // 108 - arrow down
    {"\033[5~",  ""},        // 109 - PgDown
    {"\033[2~",  ""},        // 110 - Insert
    {"\033[3~",  ""},        // 111 - Del
    {"",         ""},
    {"",         ""},
    {"",         ""},
    {"",         ""},
    {"",         ""},
    {"",         ""},
    {"",         ""},
    {"\033[P",   ""},        // 119 - Pause
    {"",         ""},
    {"",         ""},
    {"",         ""},
    {"",         ""},
    {"",         ""},
    {"",         ""},
    {"",         ""},
    {"",         ""},
};
