#ifndef __ASM_L4__GENERIC__STATS_H__
#define __ASM_L4__GENERIC__STATS_H__

#ifdef CONFIG_L4_DEBUG_STATS

#include <l4/util/atomic.h>

#define CONSTRUCT_ONE(name);			\
	extern long name;			\
	static inline void name##_hit(void)	\
	{					\
		l4util_atomic_add(&name, 1);	\
	}					\
	static inline long name##_get(void)	\
	{					\
		return name;			\
	}

#else

#define CONSTRUCT_ONE(name);			\
	static inline void name##_hit(void)	\
	{					\
	}					\
	static inline long name##_get(void)	\
	{					\
		return 0;			\
	}

#endif /* CONFIG_L4_DEBUG_STATS */

CONSTRUCT_ONE(l4x_debug_stats_suspend);
CONSTRUCT_ONE(l4x_debug_stats_pagefault);
CONSTRUCT_ONE(l4x_debug_stats_exceptions);

#undef CONSTRUCT_ONE

#endif /* ! __ASM_L4__GENERIC__STATS_H__ */
