/* L4/L4Env includes */
#include <l4/sys/types.h>
#include <l4/sys/kernel.h>
#include "rmgr.h"
#include "kinfo.h"

/*****************************************************************************
 *** DMphys internal API function
 *****************************************************************************/

/*****************************************************************************/
/**
 * \brief  Return max. phys memory address
 *	
 * \return Max. memory address
 */
/*****************************************************************************/ 
#if defined(ARCH_x86) || defined(ARCH_amd64)
l4_addr_t
root_kinfo_mem_high(void)
{
  return kip->main_memory.end;
}

l4_addr_t
root_kinfo_mem_low(void)
{
  return 0;
}

#else

enum lowhigh {
  low, high
};

static
l4_addr_t
root_kinfo_get_conventional_mem(enum lowhigh t)
{
  int i, n;
  l4_addr_t val = t == low ? ~0UL : 0UL;

  l4_kernel_info_mem_desc_t *md = l4_kernel_info_get_mem_descs(kip);

  n = l4_kernel_info_get_num_mem_descs(kip);

  /* Find conventional memory in memory descriptors */
  for (i = 0; i < n; md++, i++)
    if (   l4_kernel_info_get_mem_desc_type(md) == l4_mem_type_conventional
	&& !l4_kernel_info_get_mem_desc_is_virtual(md))
      {
	switch (t)
	  {
	  case low:
	    if (l4_kernel_info_get_mem_desc_start(md) < val)
	      val = l4_kernel_info_get_mem_desc_start(md);
	    break;
	  case high:
	    if (l4_kernel_info_get_mem_desc_end(md) > val)
	      val = l4_kernel_info_get_mem_desc_end(md);
	    break;
	  }
      }

  return val;
}

l4_addr_t
root_kinfo_mem_high(void)
{
  return root_kinfo_get_conventional_mem(high) + 1;
}

l4_addr_t
root_kinfo_mem_low(void)
{
  return root_kinfo_get_conventional_mem(low);
}

#endif

