# -*- Makefile -*-
#
# DROPS (Dresden Realtime OPerating System) Component
#
# Makefile-Template to run tests with Fiasco-UX
#
# install.inc is used, see there for further documentation

ifeq ($(origin _L4DIR_MK_RUNUX_MK),undefined)
_L4DIR_MK_RUNUX_MK=y

ROLE = runux.mk
.general.d:	$(L4DIR)/mk/runux.mk

# set a mode, so binary.inc is satisfied
MODE	?= l4env

# include all Makeconf.locals, define common rules/variables
include $(L4DIR)/mk/Makeconf
include $(L4DIR)/mk/binary.inc

# if we have a system set, build
ifneq ($(SYSTEM),)

##
# !WARNING!
#
# This is a preliminary test to allow l4check to run Fiasco-UX tests for
# multiple SYSTEMS. This currently only works for x86.
ifneq ($(ARCH),x86)
$(error "$(ROLE) currently does not support $(ARCH).")
endif

# now check if the current API has a FIASCOUX variable set and if so use it
# XXX could be overloaded by $(OSYSTEM) == $(ARCH)-$(L4API) or $(SYSTEM)
ifneq ($(FIASCOUX_$(L4API)),)
FIASCOUX = $(FIASCOUX_$(L4API))
else
$(warning "Using generic(?) Fiasco UX "$(FIASCOUX)" to test $(L4API).")
endif

# the testapplication
# test if variables are set
ifeq ($(TEST_SERVER),)
DO_TARGET	:= no_ptest
else
DO_TARGET	:= ptest
endif
# TEST_CLIENT might be empty. Testing server stand-alone
ifneq ($(TEST_CLIENT),)
TEST_CLIENT_PARAM = $(addprefix -c ,$(TEST_CLIENT))
endif
ifneq ($(BASE_SERVERS),)
BASESERVERS	= $(addprefix -b ,$(BASE_SERVERS))
endif

# expected output and what to do on mismatch
EXPECTED_OUT	?= expected.txt
TIMEOUT		?= 10
DEBUG_PERL	?= 0
TMP_OUT		?= tmp_out.txt

# specify files to delete when doing 'make clean'
DEL_ON_CLEAN	= $(TMP_OUT) core

ifneq ($(DEBUG_PERL),0)
DEBUG_PERL_	= -v
else
DEBUG_PERL_	=
endif

ifneq ($(MEMORY),)
MEMORY_		= -m $(MEMORY)
endif

# allow failure of test
# 
# If EXPECT_FAIL is set, the test if the output matches must fail, otherwise
# ptest will return an error.
ifeq ($(EXPECT_FAIL),1)
EXPECT_FAIL_	= --expectfail
else
EXPECT_FAIL_	=
endif

# do keep ALL output
#
# if FILTER_KEEP_ALL is set, the Fiasco UX output is only filtered for escape
# sequences. All other output is printed into temporary file
ifeq ($(FILTER_KEEP_ALL),1)
FILTER_KEEP_	= --filterlevel=0
else
FILTER_KEEP_	=
endif

# no framebuffer device
#
# If NO_FBUF_DEV is set, Fiasco UX will not open an X window to display
# graphical output. This is useful for testing graphical applications.
ifeq ($(NO_FBUF_DEV),1)
NO_FBUF_DEV_	= --nofb
else
NO_FBUF_DEV_	=
endif

# enable symbols and lines per default
USE_SYMBOLS	?= y
USE_LINES	?= y

ifeq ($(USE_SYMBOLS),y)
USE_SYMBOLS_	= --symbols
else
USE_SYMBOLS_	=
endif
ifeq ($(USE_LINES),y)
USE_LINES_	= --lines
else
USE_LINES_	=
endif

all:: $(DO_TARGET)

# install.inc eventually defines rules for every target
include $(L4DIR)/mk/install.inc

no_ptest:
	@echo "No test defined, skipping"

ptest:: $(EXPECTED_OUT) $(BID_OBJ_Makefile).inc
	$(VERBOSE)echo "Running Fiasco UX to test $(TEST_SERVER)"
	$(VERBOSE)EXPECTED_OUT=$(EXPECTED_OUT) PKGNAME=$(PKGNAME) \
		L4DIR=$(L4DIR) OBJ_BASE=$(OBJ_BASE) TMP_OUT=$(TMP_OUT) \
		COMPARE_CMD=$(COMPARE_CMD) \
		$(L4DIR)/mk/ptest -s $(TEST_SERVER) $(TEST_CLIENT_PARAM) \
		-f $(FIASCOUX) -t $(TIMEOUT) -O OBJ-$(SYSTEM) \
		$(BASESERVERS) $(DEBUG_PERL_) $(MEMORY_) $(EXPECT_FAIL_) \
		$(FILTER_KEEP_) $(NO_FBUF_DEV_) $(USE_SYMBOLS_) $(USE_LINES_)

genexp:: $(EXPECTED_OUT) $(BID_OBJ_Makefile).inc

$(EXPECTED_OUT):
	$(VERBOSE)echo "Running Fiasco UX to generate expected output"
	$(VERBOSE)EXPECTED_OUT=$(EXPECTED_OUT) PKGNAME=$(PKGNAME) \
		L4DIR=$(L4DIR) OBJ_BASE=$(OBJ_BASE) TMP_OUT=$(TMP_OUT) \
		COMPARE=$(COMPARE_CMD) \
		$(L4DIR)/mk/ptest -s $(TEST_SERVER) $(TEST_CLIENT_PARAM) \
		-f $(FIASCOUX) -t $(TIMEOUT) -O OBJ-$(SYSTEM) \
		$(BASESERVERS) $(DEBUG_PERL_) $(MEMORY_) $(EXPECT_FAIL_) \
		$(FILTER_KEEP_) $(NO_FBUF_DEV_) $(USE_SYMBOLS_) $(USE_LINES_) \
		--generate
	$(VERBOSE)touch .expect-autogenerated

plainrun:: $(BID_OBJ_Makefile).inc
	$(VERBOSE)echo "Starting Fiasco UX"
	$(VERBOSE)EXPECTED_OUT=$(EXPECTED_OUT) PKGNAME=$(PKGNAME) \
		L4DIR=$(L4DIR) OBJ_BASE=$(OBJ_BASE) TMP_OUT=$(TMP_OUT) \
		COMPARE_CMD=$(COMPARE_CMD) \
		$(L4DIR)/mk/ptest -s $(TEST_SERVER) $(TEST_CLIENT_PARAM) \
		-f $(FIASCOUX) -t $(TIMEOUT) -O OBJ-$(SYSTEM) \
		$(BASESERVERS) $(DEBUG_PERL_) $(MEMORY_) $(FILTER_KEEP_) \
		$(NO_FBUF_DEV_) $(USE_SYMBOLS_) $(USE_LINES_) --plainrun

endif # system defined

ptest genexp plainrun:: $(foreach arch,$(TARGET_SYSTEMS),\
			$(OBJ_DIR)/OBJ-$(arch)/$(BID_OBJ_Makefile))
	$(if $(TARGET_SYSTEMS),  $(VERBOSE)set -e ; \
	    for d in $(TARGET_SYSTEMS) ; do \
	    	PWD=$(OBJ_DIR)/OBJ-$$d $(MAKE) -C $(OBJ_DIR)/OBJ-$$d -f $(BID_OBJ_Makefile) \
			$@ ; done )

.PHONY: all ptest genexp plainrun clean cleanall help no_ptest
-include $(DEPSVAR)

help::
	@echo "Specify a target:"
	@echo "all       - run test"
	@echo "test      - run test"
	@echo "genexp    - generate file with expected output"
	@echo "plainrun  - just run binaries (no filter, no comparison)"
	@echo "clean     - delete generated intermediate files"
	@echo "cleanall  - delete all generated files (include genexp target)"
	@echo "help      - this help"
	@echo

endif	# _L4DIR_MK_RUNUX_MK undefined
