.\"Warning: don't edit this file. It has been generated by typeset
.\" The next compilation will silently overwrite all changes.
.TH "Fiasco" 1 "1998/10/15" "DROPS" "User Commands"
.SH NAME
 Fiasco \- L4\-compatible real\-time \(*m\-kernel

.SH "Synopsis"
\fBmain\fP
[\fB\-nowait\fP]
[\fB\-nojdb\fP]
[\fB\-nokdb\fP]
[\fB\-noscreen\fP]
[\fB\-noserial\fP]
[\fB\-comspeed=\fP\fIn\fP]
[\fB\-comport=\fP\fIn\fP]
[\fB\-hercules\fP]
[\fB\-serial_esc\fP]
[\fB\-tbuf_entries=\fP\fIn\fP]
[\fB\-out_buf=\fP\fIn\fP]
[\fB\-esc\fP]
[\fB\-kmemsize=\fP\fIn\fP]
[\fB\-watchdog\fP]
[\fB\-loadcnt\fP]
[\fB\-apic\fP]
[\fB\-profile\fP]
[\fB\-profstart\fP]
[\fB\-irq0\fP]
[\fB\-irqcom\fP|\fB\-I\-\fP]
[\fB\-jdb_cmd=\fP\fIcommands\fP]
[\fB\-always_irqack\fP]\fB proto=\fP\fIphysical_address\fP

.SH "Description"
Fiasco is a new \(*m\-kernel (microkernel) running on x86 PCs intended to
be compatible with the L4/x86 \(*m\-kernel for x86. It implements the L4 ABI
as defined in the L4/x86 Reference Manual. The Fiasco kernel can be
used to construct flexible systems. We at TU Dresden are using it as a
base for our DROPS system which supports a running real\-time and
time\-sharing application concurrently on one computer. However, Fiasco
is not only suitable for big and complex systems, but also for small,
embedded applications.
.SH "Options"
.IP "\fB\-nowait\fP"
Removes the initial ``KDB: init'' breakpoint. The
installation instructions on the Fiasco web site recommend this
option; if you plan to do some serious debugging, you shouldn't use it.
.IP "\fB\-nojdb\fP"
Disables the builtin kernel debugger JDB.
.IP "\fB\-nokdb\fP"
Disables the GDB stub. Should Fiasco raise an exception,
it will just call the builtin jdb.
.IP "\fB\-noscreen\fP"
Disables output to vga/hercules console.
.IP "\fB\-noserial\fP"
Disables output to serial console. If this switch is
not given, kernel messages will output additionally to the serial interface.
If \fB\-nokdb\fP is enabled, you can use a terminal program on the host to
control Fiasco. If you are connected to a remote GDB, messages are copied to
GDB's console.
.IP "\fB\-comspeed=\fP\fIn\fP"
Will set the rate of the serial interface to n
bytes/second. 115200 bytes/second is the default.
.IP "\fB\-comport=\fP\fIn\fP"
Will use COMn for serial
communication. COM1 is the default. Possible values for \fIn\fP are 1,
2, 3, and 4. n is used as I/O port if n>4.
.IP "\fB\-hercules\fP"
Redirect kernel messages to the Hercules (or
other MGA\-compatible) console.
.IP "\fB\-esc\fP"
Enable esc hack. On every timer interrupt, ask the
keyboard if the Escape key was pressed. If so, do enter into kernel
debugger. Applications (e.g. L4Linux) may be confused by dropped
key events so better use \fB\-serial_esc\fP.
.IP "\fB\-kmemsize=\fP\fIn\fP"
Overwrite Fiasco's heuristic for required
kernel memory. Set the memory reserved for mapping trees, TCBs, and other
to \fIn\fPMB.
.IP "\fB\-watchdog\fP"
Enable watchdog. On every timer interrupt, tell
the watchdog that we are sill alive. If a task disables the interrupts
and loops, the timer interrupt is'nt called anymore and after 2 seconds
the watchdog releases an non maskable interrupt (NMI) which forces
Fiasco to step into the kernel debugger. Works on >= Intel PPro and
>= AMD K7 Model 2.
.IP "\fB\-loadcnt\fP"
Initialize a performance counter for counting all
cycles the CPU is not halted. The counter is accessible from userland
via rdpmc(x) where x is 0 on P6/K7, and P4.
.IP "\fB\-apic\fP"
Initialize the builtin Local APIC. If the Local APIC is
disabled by the BIOS but available, it is re\-enabled.
.IP "\fB\-serial_esc\fP"
Enter jdb on serial receive interrupts. This
is only necessary if kdb was disabled by \fB\-nokdb\fP.
.IP "\fB\-tbuf_entries=\fP\fIn\fP"
Set number of lines to store in the 
debugging trace buffer. Default is 1024.
.IP "\fB\-out_buf=\fP\fIn\fP"
Set output buffer for kd_display functions
to n bytes. Default is 4096.
.IP "\fB\-profile\fP"
Enable kernel profiling support; you need to
compile it with \fB\-DPROFILE\fP for this to work. Profiling needs to
be started with either the \fB\-profstart\fP option or using the
kernel\-debugger interface. When you terminate Fiasco (e.g., using the
remote debugger), the profiling information is printed in uuencoded
4.4BSD gmon.out format to the serial interface; you can capture it
using a terminal program.
.IP
Unfortunately, current versions of GNU `gprof' don't understand the
4.4BSD gmon.out format; the next version hopefully does. I've sent a
patch to the `gprof' maintainer (the patch is also available on
request from me).
.IP "\fB\-profstart\fP"
Immediately start profiling after boot. This
option requires the \fB\-profile\fP option.
.IP "\fB\-irq0\fP"
Enable IRQ0 for user tasks. Normally, IRQ0 is
reserved for kernel use.
.IP "\fB\-irqcom\fP or \fB\-I\-\fP"
Disable for user tasks the IRQ
associated with the serial port used for I/O or the kernel debugger.
.IP "\fB\-jdb_cmd=\fP\fIcommands\fP"
Execute Jdb commands non\-interactive at
startup.
.IP "\fB\-always_irqack\fP"
IRQs are acknowledged by the kernel. Your
userland code has to know this!
.IP "\fBproto=\fP\fIphysical_address\fP"
This argument is automatically
added by RMGR when starting Fiasco. It communicates the address of a
template for the kernel's info page which contains configuration
information for Fiasco. For details on the kernel info page, please
see the L4 Reference Manual.
.SH "Booting"
Fiasco should be booted using RMGR. Please see the RMGR manual page
for details.
.PP
It is important to load a Sigma0 server along with Fiasco, because
unlike L4/x86, Fiasco doesn't contain its own Sigma0 implementation. Here
is a sample GRUB configuration file (menu.lst) which accomplishes
this:
.RS
.sp
.nf
\fBtitle Fiasco
# RMGR is the boot kernel
kernel (fd0)/rmgr \-configfile \-sigma0
# The Fiasco kernel must be the first boot module
module (fd0)/main \-nowait
# Sigma0
module (fd0)/sigma0
# The RMGR config file (if any) must come just before the boot servers
module (fd0)/rmgr.cfg
# Boot server tasks follow
module (fd0)/glinux.gz root=/dev/sda5
module (fd0)/hello\fP
.fi
.RE
.sp
.SH "Bugs"
Many.
.PP
Please report bugs to <l4\-hackers@os.inf.tu\-dresden.de>.
.SH "See Also"
 rmgr 

.PP
L4 Reference Manual
.PP
 http://www.gnu.org/software/grub/ GRUB, the Grand Unified Bootloader

.PP
 http://www.uruk.org/grub/boot\-proposal.html Multiboot
standard proposal
