/**
 *  \file   dice/src/be/l4/TypeSpec-L4Types.h
 *  \brief  contains the declaration defines used with L4 types
 *
 *  \date   11/01/2004
 *  \author Ronald Aigner <ra3@os.inf.tu-dresden.de>
 */
/*
 * Copyright (C) 2001-2004
 * Dresden University of Technology, Operating Systems Research Group
 *
 * This file contains free software, you can redistribute it and/or modify
 * it under the terms of the GNU General Public License, Version 2 as
 * published by the Free Software Foundation (see the file COPYING).
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * For different licensing schemes please contact
 * <contact@os.inf.tu-dresden.de>.
 */

/** preprocessing symbol to check header file */
#ifndef __DICE_TYPESPEC_L4TYPES_H__
#define __DICE_TYPESPEC_L4TYPES_H__

#include "TypeSpec-Type.h"

/** \def TYPE_MSGDOPE_SIZE
 *  \brief imitates a new type
 *
 * This is used to support the size and send dopes of the
 * message buffer using WriteMemberAccess. Value is 37.
 */
#define TYPE_MSGDOPE_SIZE  (TYPE_MAX + 1)

/** \def TYPE_MSGDOPE_SEND
 *  \brief imitates a new type
 *  \see TYPE_MSGDOPE_SIZE
 *
 * Value is 38.
 */
#define TYPE_MSGDOPE_SEND  (TYPE_MAX + 2)

/** \def TYPE_MAX_L4
 *  \brief maximum type number for L4
 */
#define TYPE_MAX_L4  TYPE_MSGDOPE_SEND


#endif /* !__DICE_TYPESPEC_L4TYPES_H__ */
