/**
 *    \file    dice/src/be/BETypedDeclarator.h
 *  \brief   contains the declaration of the class CBETypedDeclarator
 *
 *    \date    01/18/2002
 *    \author  Ronald Aigner <ra3@os.inf.tu-dresden.de>
 */
/*
 * Copyright (C) 2001-2004
 * Dresden University of Technology, Operating Systems Research Group
 *
 * This file contains free software, you can redistribute it and/or modify
 * it under the terms of the GNU General Public License, Version 2 as
 * published by the Free Software Foundation (see the file COPYING).
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * For different licensing schemes please contact
 * <contact@os.inf.tu-dresden.de>.
 */

/** preprocessing symbol to check header file */
#ifndef __DICE_BETYPEDDECLARATOR_H__
#define __DICE_BETYPEDDECLARATOR_H__

#define LANG_PROP_C_ATTRIBUTE  (1) /**< C style attributes */
#define LANG_PROP_C_ASMREG     (2) /**< assember register */
#define LANG_PROP_C_DEFINED    (3) /**< symbol defined */
#define LANG_PROP_C_NDEFINED   (4) /**< symbol not defined */
#define LANG_PROP_C_NO_CONST   (5) /**< no const qualifier */
#define LANG_PROP_C_MAX        (5) /**< maximum index of C properties */

#include "be/BEObject.h"
#include <vector>
#include <map>
using namespace std;

class CFETypedDeclarator;
class CFEAttribute;
class CBEContext;
class CBEType;
class CBEAttribute;
class CBEFile;
class CBEHeaderFile;
class CBEImplementationFile;
class CBEDeclarator;
class CDeclaratorStackLocation;
class CBEConstant;

/** \class CBETypedDeclarator
 *  \ingroup backend
 *  \brief the back-end parameter
 */
class CBETypedDeclarator : public CBEObject
{
// Constructor
public:
    /** \brief constructor
     */
    CBETypedDeclarator();
    virtual ~CBETypedDeclarator();

protected:
    /** \brief copy constructor
     *  \param src the source to copy from
     */
    CBETypedDeclarator(CBETypedDeclarator & src);

public:
    virtual void CreateBackEnd(CBEType * pType, string sName)
	throw (CBECreateException*);
    virtual void CreateBackEnd(string sUserDefinedType, string sName, 
	int nStars)
	throw (CBECreateException*);
    virtual void CreateBackEnd(CFETypedDeclarator * pFEParameter)
	throw (CBECreateException*);

    int GetSize();
    int GetSize(string sName);
    CBEType *GetType();
    int GetBitfieldSize();
    bool GetMaxSize(bool bGuessSize, int & nSize, string sName = string());

    void ReplaceType(CBEType * pNewType);

    virtual bool IsVariableSized();
    bool IsString();
    bool IsDirection(int nDirection);
    bool IsFixedSized();
    bool HasSizeAttr(int nAttr);
    bool HasReference();

    CBEDeclarator* FindDeclarator(string sName);
    CBEDeclarator *GetNextDeclarator(vector<CBEDeclarator*>::iterator &iter);
    CBEDeclarator *GetDeclarator();
    CBEDeclarator *GetCallDeclarator();
    void RemoveCallDeclarator();
    vector<CBEDeclarator*>::iterator GetFirstDeclarator();
    bool IsLastDeclarator(vector<CBEDeclarator*>::iterator iter);
    void RemoveDeclarator(CBEDeclarator * pDeclarator);
    void AddDeclarator(CBEDeclarator * pDeclarator);

    CBEAttribute* FindIsAttribute(string sDeclName);
    CBEAttribute *FindAttribute(int nAttrType);
    CBEAttribute *GetNextAttribute(vector<CBEAttribute*>::iterator &iter);
    vector<CBEAttribute*>::iterator GetFirstAttribute();
    void RemoveAttribute(CBEAttribute * pAttribute);
    void AddAttribute(CBEAttribute * pAttribute);

    /** \brief creates a new instance of this class 
     *  \return a reference to the copy
     */
    virtual CObject *Clone()
    { return new CBETypedDeclarator(*this); }

    /** \brief sets the default initialization string
     *  \param sInitString the new initializatio string (may be empty)
     */
    void SetDefaultInitString(string sInitString)
    { m_sDefaultInitString = sInitString; }
    /** \brief accesses the default initialization string
     *  \return the value of the default initialization string
     */
    string GetDefaultInitString(void)
    { return m_sDefaultInitString; }

    bool AddLanguageProperty(int nProperty, string sPropertyString);
    bool FindLanguageProperty(int nProperty, string& sPropertyString);

    void WriteDeclarators(CBEFile * pFile);

    // delegated to langauge dependent part
    virtual void WriteDefinition(CBEFile *pFile);
    virtual void WriteDeclaration(CBEFile * pFile);
    void WriteSetZero(CBEFile* pFile);
    void WriteGetSize(CBEFile * pFile, 
	vector<CDeclaratorStackLocation*> *pStack, CBEFunction *pUsingFunc);
    void WriteGetMaxSize(CBEFile * pFile, 
	vector<CDeclaratorStackLocation*> *pStack, CBEFunction *pUsingFunc);
    void WriteCleanup(CBEFile* pFile);
    void WriteDeferredCleanup(CBEFile* pFile);
    void WriteType(CBEFile * pFile, bool bUseConst = true);
    void WriteIndirect(CBEFile * pFile);
    void WriteIndirectInitialization(CBEFile * pFile);
    void WriteIndirectInitializationMemory(CBEFile * pFile);
    void WriteInitDeclaration(CBEFile* pFile, string sInitString);
    void AddAttribute(CFEAttribute *pFEAttribute)
	throw (CBECreateException*);
    // language specific
    virtual void WriteForwardDeclaration(CBEFile *pFile);
    virtual void WriteForwardTypeDeclaration(CBEFile * pFile,
	bool bUseConst = true);

protected:
    int GetSizeOfDeclarator(CBEDeclarator *pDeclarator);
    CBEType* GetTransmitType();
    CBETypedDeclarator* GetSizeVariable(CBEAttribute *pIsAttribute,
	vector<CDeclaratorStackLocation*> *pStack, CBEFunction *pUsingFunc,
	bool& bFoundInStruct);
    CBEConstant* GetSizeConstant(CBEAttribute *pIsAttribute);

    virtual void WriteAttributes(CBEFile * pFile);
    virtual void WriteConstPrefix(CBEFile *pFile);
    virtual void WriteProperties(CBEFile *pFile);

protected:
    /** \var CBEType *m_pType
     *  \brief the type of the parameter
     */
    CBEType * m_pType;
    /** \var vector<CBEAttribute*> m_vAttributes
     *  \brief contains the type's attributes
     */
    vector<CBEAttribute*> m_vAttributes;
    /** \var vector<CBEDeclarator*> m_vDeclarators
     *  \brief the names of the parameter
     */
    vector<CBEDeclarator*> m_vDeclarators;
    /** \var string m_sDefaultInitString
     *  \brief contains the initialization sequence if no other is given
     */
    string m_sDefaultInitString;
    /** \var map<int, string> m_mProperties
     *  \brief map with language specific properties
     */
    multimap<int, string> m_mProperties;
};


#endif                //*/ !__DICE_BETYPEDDECLARATOR_H__
