/**
 *    \file    dice/src/be/BERoot.h
 *  \brief   contains the declaration of the class CBERoot
 *
 *    \date    01/10/2002
 *    \author  Ronald Aigner <ra3@os.inf.tu-dresden.de>
 */
/*
 * Copyright (C) 2001-2004
 * Dresden University of Technology, Operating Systems Research Group
 *
 * This file contains free software, you can redistribute it and/or modify
 * it under the terms of the GNU General Public License, Version 2 as
 * published by the Free Software Foundation (see the file COPYING).
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * For different licensing schemes please contact
 * <contact@os.inf.tu-dresden.de>.
 */

/** preprocessing symbol to check header file */
#ifndef __DICE_BEROOT_H__
#define __DICE_BEROOT_H__

#include "be/BEObject.h"
#include <vector>
using namespace std;

class CBEClient;
class CBEComponent;
class CBEClass;
class CBETypedef;
class CBEType;
class CBEFunction;
class CBENameSpace;
class CBEConstant;
class CBEImplementationFile;
class CBEHeaderFile;

class CFETypedDeclarator;
class CFEConstDeclarator;
class CFEConstructedType;
class CFEInterface;
class CFELibrary;
class CFEFile;

/**    \class CBERoot
 *    \ingroup backend
 *  \brief the root of the back-end structure
 */
class CBERoot : public CBEObject
{
// Constructor
public:
    /** \brief constructor
     */
    CBERoot();
    ~CBERoot();

protected:
    /** \brief copy constructor
     *  \param src the source to copy from
     */
    CBERoot(CBERoot &src);

public: // Public methods
    CBEFunction* FindFunction(string sFunctionName, int nFunctionType);
    void Write();
    void CreateBE(CFEFile *pFEFile) 
	throw (CBECreateException*);

    CBETypedef* FindTypedef(string sTypeName);
    CBETypedef* GetNextTypedef(vector<CBETypedef*>::iterator &iter);
    vector<CBETypedef*>::iterator GetFirstTypedef();
    void RemoveTypedef(CBETypedef *pTypedef);
    void AddTypedef(CBETypedef *pTypedef);

    CBEConstant* FindConstant(string sConstantName);
    CBEConstant* GetNextConstant(vector<CBEConstant*>::iterator &iter);
    vector<CBEConstant*>::iterator GetFirstConstant();
    void RemoveConstant(CBEConstant *pConstant);
    void AddConstant(CBEConstant *pConstant);

    CBENameSpace* FindNameSpace(string sNameSpaceName);
    CBENameSpace* GetNextNameSpace(vector<CBENameSpace*>::iterator &iter);
    vector<CBENameSpace*>::iterator GetFirstNameSpace();
    void RemoveNameSpace(CBENameSpace *pNameSpace);
    void AddNameSpace(CBENameSpace*pNameSpace);

    CBEClass* FindClass(string sClassName);
    CBEClass* GetNextClass(vector<CBEClass*>::iterator &iter);
    vector<CBEClass*>::iterator GetFirstClass();
    void RemoveClass(CBEClass *pClass);
    void AddClass(CBEClass *pClass);

    bool AddToFile(CBEImplementationFile *pImpl);
    bool AddToFile(CBEHeaderFile *pHeader);
    bool AddOpcodesToFile(CBEHeaderFile *pHeader, CFEFile *pFEFile);

    CBEFunction* FindGlobalFunction(string sFuncName);
    CBEFunction* GetNextGlobalFunction(vector<CBEFunction*>::iterator &iter);
    vector<CBEFunction*>::iterator GetFirstGlobalFunction();
    void RemoveGlobalFunction(CBEFunction *pFunction);
    void AddGlobalFunction(CBEFunction *pFunction);
    void PrintTargetFiles(FILE *output, int &nCurCol, int nMaxCol);

    CBEType* FindTaggedType(int nType, string sTag);
    CBEType* GetNextTaggedType(vector<CBEType*>::iterator &iter);
    vector<CBEType*>::iterator GetFirstTaggedType();
    void AddTaggedType(CBEType *pType);
    void RemoveTaggedType(CBEType *pType);

protected: // Protected methods
    void CreateBackEnd(CFEConstDeclarator *pFEConstant)
	throw (CBECreateException*);
    void CreateBackEnd(CFEInterface *pFEInterface)
	throw (CBECreateException*);
    void CreateBackEnd(CFELibrary *pFELibrary)
	throw (CBECreateException*);
    void CreateBackEnd(CFETypedDeclarator *pFETypedef)
	throw (CBECreateException*);
    void CreateBackEnd(CFEFile *pFEFile)
	throw (CBECreateException*);
    void CreateBackEnd(CFEConstructedType *pFEType)
	throw (CBECreateException*);

protected:
    /** \var CBEClient *m_pClient
     *  \brief reference to client part
     *
     * This variable is a reference, because we use the ClassFactory, which
     * only returns references.
     */
    CBEClient *m_pClient;
    /** \var CBEComponent *m_pComponent
     *  \brief reference to component part
     */
    CBEComponent *m_pComponent;
    /** \var vector<CBEConstant*> m_vConstants
     *  \brief contains the constants of the back-end
     */
    vector<CBEConstant*> m_vConstants;
    /** \var vector<CBETypedef*> m_vTypedefs
     *  \brief contains the type definitions of the back-end
     */
    vector<CBETypedef*> m_vTypedefs;
    /** \var vector<CBEType*> m_vTypeDeclarations
     *  \brief contains the type declarations, which are not typedefs (usually
     *         tagged)
     */
    vector<CBEType*> m_vTypeDeclarations;
    /** \var vector<CBEClass*> m_vClasses
     *  \brief contains the classes of the back-end
     */
    vector<CBEClass*> m_vClasses;
    /** \var vector<CBENameSpace*> m_vNamespaces
     *  \brief contains the namespaces of the back-end
     */
    vector<CBENameSpace*> m_vNamespaces;
    /** \var vector<CBEFunction*> m_vGlobalFunctions
     *  \brief contains global functions (outside of classes and name-spaces)
     */
    vector<CBEFunction*> m_vGlobalFunctions;
};

#endif // !__DICE_BEROOT_H__
