/**
 *    \file    dice/src/be/BEMarshalFunction.h
 *  \brief   contains the declaration of the class CBEMarshalFunction
 *
 *    \date    10/09/2003
 *    \author  Ronald Aigner <ra3@os.inf.tu-dresden.de>
 */
/*
 * Copyright (C) 2001-2004
 * Dresden University of Technology, Operating Systems Research Group
 *
 * This file contains free software, you can redistribute it and/or modify
 * it under the terms of the GNU General Public License, Version 2 as
 * published by the Free Software Foundation (see the file COPYING).
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * For different licensing schemes please contact
 * <contact@os.inf.tu-dresden.de>.
 */

/** preprocessing symbol to check header file */
#ifndef CBEMARSHALFUNCTION_H
#define CBEMARSHALFUNCTION_H

#include <be/BEOperationFunction.h>

/** \class CBEMarshalFunction
 *  \ingroup backend
 *  \brief the marshalling function class for the back-end
 *
 * This class contains a back-end function which belongs to a front-end
 * operation
 */
class CBEMarshalFunction : public CBEOperationFunction
{
// Constructor
public:
    /** \brief constructor
     */
    CBEMarshalFunction();
    virtual ~CBEMarshalFunction();

protected:
    /** \brief copy constructor */
    CBEMarshalFunction(CBEMarshalFunction &src);

public:
    virtual void CreateBackEnd(CFEOperation *pFEOperation)
	throw (CBECreateException*);
    virtual bool MsgBufferInitialization(CBEMsgBuffer *pMsgBuffer);
    virtual void WriteReturn(CBEFile * pFile);
    virtual int GetFixedSize(int nDirection);
    virtual int GetSize(int nDirection);
    virtual int GetReceiveDirection();
    virtual int GetSendDirection();
    virtual CBETypedDeclarator* FindParameterType(string sTypeName);
    virtual bool DoMarshalParameter(CBETypedDeclarator * pParameter, 
	    bool bMarshal);
    virtual void AddParameter(CFETypedDeclarator * pFEParameter)
	throw (CBECreateException*);
    virtual bool DoWriteFunction(CBEHeaderFile* pFile);
    virtual bool DoWriteFunction(CBEImplementationFile* pFile);

    virtual CBETypedDeclarator* GetExceptionVariable(void);

protected:
    virtual int GetReturnSize(int nDirection);
    virtual int GetFixedReturnSize(int nDirection);
    virtual int GetMaxReturnSize(int nDirection);
    virtual void WriteInvocation(CBEFile * pFile);
    virtual void WriteVariableInitialization(CBEFile * pFile);
    virtual void AddAfterParameters()
	throw (CBECreateException*);
    virtual void AddBeforeParameters()
	throw (CBECreateException*);
};

#endif
