/**
 *    \file    dice/src/be/BEContext.h
 *  \brief   contains the declaration of the class CBEContext
 *
 *    \date    01/10/2002
 *    \author  Ronald Aigner <ra3@os.inf.tu-dresden.de>
 */
/*
 * Copyright (C) 2001-2004
 * Dresden University of Technology, Operating Systems Research Group
 *
 * This file contains free software, you can redistribute it and/or modify
 * it under the terms of the GNU General Public License, Version 2 as
 * published by the Free Software Foundation (see the file COPYING).
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * For different licensing schemes please contact
 * <contact@os.inf.tu-dresden.de>.
 */

/** preprocessing symbol to check header file */
#ifndef __DICE_BE_BECONTEXT_H__
#define __DICE_BE_BECONTEXT_H__

#include "be/BEObject.h"
#include "be/BEFile.h"

//@{
/** function types */
#define FUNCTION_SEND               0x01  /**< the send function */
#define FUNCTION_RECV               0x02  /**< the receive function */
#define FUNCTION_WAIT               0x03  /**< the wait function */
#define FUNCTION_UNMARSHAL          0x04  /**< the unmarshal function */
#define FUNCTION_MARSHAL            0x05  /**< the marshal function */
#define FUNCTION_REPLY_RECV         0x06  /**< the reply-and-receive function */
#define FUNCTION_REPLY_WAIT         0x07  /**< the reply-and-wait function */
#define FUNCTION_CALL               0x08  /**< the call function */
#define FUNCTION_TEMPLATE           0x09  /**< the server function template */
#define FUNCTION_WAIT_ANY           0x0a  /**< the wait any function */
#define FUNCTION_RECV_ANY           0x0c  /**< the receive any function */
#define FUNCTION_SRV_LOOP           0x0d  /**< the server loop function */
#define FUNCTION_DISPATCH           0x0e  /**< the dispatch function */
#define FUNCTION_SWITCH_CASE        0x0f  /**< the switch case statement */
#define FUNCTION_REPLY              0x11  /**< the reply only function */
//@}

//@{
/** file type options */
#define FILETYPE_CLIENTHEADER               0x01
#define FILETYPE_CLIENTIMPLEMENTATION       0x02
#define FILETYPE_COMPONENTHEADER            0x03
#define FILETYPE_COMPONENTIMPLEMENTATION    0x04
#define FILETYPE_OPCODE                     0x06
#define FILETYPE_TEMPLATE                   0x07
#define FILETYPE_CLIENT                     0x08 /**< includes header and implementation file */
#define FILETYPE_COMPONENT                  0x09 /**< includes header and implementation file */
#define FILETYPE_HEADER                     0x0a /**< includes client, server and sys header file */
#define FILETYPE_IMPLEMENTATION             0x0b /**< includes client and server implementation file */
//@}

/** \class CBEContext
 *  \ingroup backend
 *  \brief The context class of the back-end
 *
 * This class contains information, which makes up the context of the write
 * operation.  E.g. the target file, the class and name factory, and some
 * additional options.
 */
class CBEContext : public CBEObject
{
// Constructor
public:
    /** \brief constructs a back-end context object  */
    CBEContext();
    ~CBEContext();

// Operations
public:
    static void WriteMalloc(CBEFile* pFile, CBEFunction* pFunction);
    static void WriteFree(CBEFile* pFile, CBEFunction* pFunction);
    static void WriteMemory(CBEFile *pFile, CBEFunction *pFunction,
	string sEnv, string sCorba);
};

#endif                // __DICE_BE_BECONTEXT_H__
