/****************************************************************
 * Generic send functions for ORe.                              *
 *                                                              *
 * Generic part of ORe's tx functionality.                      *
 *                                                              *
 * Bjoern Doebel <doebel@os.inf.tu-dresden.de>                  *
 * 2005-08-10                                                   *
 ****************************************************************/

#include <dice/dice.h>

#include "ore-local.h"

/* Send component function.
 *
 * - perform sanity and security checks
 * - call the client's real send function
 */
CORBA_int ore_rxtx_send_component(CORBA_Object _dice_corba_obj,
                       const CORBA_char *buf,
                       l4_size_t size,
                       CORBA_Server_Environment *_dice_corba_env)
{
  int ret = 0;
  int channel = *(int *)l4thread_data_get_current(__l4ore_tls_id_key);
  
  LOGd(ORE_DEBUG_COMPONENTS, "send on channel %d", channel);

  ret = sanity_check_rxtx(channel, *_dice_corba_obj);
  if (ret < 0)
      return ret;
  
  if (ore_connection_table[channel].config.rw_active == 0)
    {
      LOG_Error("Trying to send via inactive connection.");
      ret = -L4_EBADF;
    }

  // still no error? then go on
  if (!ret)
    ret = ore_connection_table[channel].tx_component_func(
                _dice_corba_obj, buf, size, _dice_corba_env);

  return ret;
}

