#include <stdlib.h>
#include <stdio.h>

#include <l4/log/l4log.h>
#include <l4/util/util.h>
#include <l4/ore/uip-ore.h>
#include <l4/thread/thread.h>

#include <l4/ferret/monitor.h>
#include <l4/ferret/types.h>
#include <l4/ferret/util.h>
#include <l4/ferret/sensors/list_consumer.h>

#include "sensor.h"

char LOG_tag[9] = "arp_mon";

static int connected = 0;

static void connect_callback(const struct in_addr ip);
static void abort_callback(void);

static void connect_callback(const struct in_addr ip)
{
    connected = 1;
}

static void abort_callback(void)
{
    connected = 0;
}

int main(int argc, char **argv)
{
    int cnt, i, ret;
    static const int max_cnt = 50;
    ferret_monitor_list_entry_t entries[max_cnt];
    ferret_monitor_list_entry_t *ent = entries;
    ferret_list_moni_t  *list;
    arping_event *ev = malloc(sizeof(arping_event));
    
    uip_ore_config c;
    l4thread_t t;

    strcpy(c.ip, "141.76.48.47");
    c.port_nr           = 1234;
    c.recv_callback     = NULL;
    c.ack_callback      = NULL;
    c.rexmit_callback   = NULL;
    c.connect_callback  = connect_callback;
    c.abort_callback    = abort_callback;

    t = l4thread_create(uip_ore_thread, &c, L4THREAD_CREATE_SYNC);
    
    l4_sleep(3000);

    LOG("Listing content of sensor directory:");
    LOG("====================================");
    cnt = ferret_list(&ent, max_cnt, 0);
    for (i = 0; i<cnt; i++)
    {
        LOG("%hu, %hu, %hu, %hu, %u", ent[i].major, ent[i].minor,
                ent[i].instance, ent[i].type, ent[i].id);
    }

    ret = ferret_att(ARPING_SENSOR_MAJOR, ARPING_SENSOR_MINOR, 0, list);
    LOG("attached to arping sensor: %d", ret);

    while(1)
    {
        if (list)
        {
            int num_ev = 0;
            // while there is sensor data
            while ((ret = ferret_list_get(list, (ferret_list_entry_t *)ev)) == 0)
            {
                switch(ev->head.type)
                {
                    case ARPING_IPC_EVENT:
                        LOG("* IPC Event. Sender = %02x.%02x, Handle = %d",
                                ev->head.taskno, ev->head.threadno, ev->ipc.handle);
                        if (ev->ipc.flags & ARPING_IPC_RECV_FLAG)
                            LOG("   received %d bytes.", ev->ipc.size_recv);
                        if (ev->ipc.flags & ARPING_IPC_SEND_FLAG)
                            LOG("   sent %d bytes.", ev->ipc.size_send);
                        LOG("   duration: %lld cycles", 
                                ev->ipc.stop_ts - ev->ipc.start_ts);
                        break;
                    case ARPING_PARSE_EVENT:
                        LOG("* Arping PARSE call.");
                        LOG("   duration: %lld cycles", 
                                ev->void_call.stop_ts - ev->void_call.start_ts);
                        break;
                    case ARPING_CREATE_REPLY_EVENT:
                        LOG("* Arping CREATE_REPLY call.");
                        LOG("   duration: %lld cycles", 
                                ev->void_call.stop_ts - ev->void_call.start_ts);
                        break;
                    default:
                        LOG("unknown event.");
                }
                num_ev++;

                if (connected)
                {
                    uip_ore_send((char *)ev, sizeof(arping_event));
                }
            }
            if (num_ev)
                LOG("--==--==--==--==--==--==--==--");
        }
        else 
        {
            // do nothing
        }
        l4_sleep(500);
    }
}
