/* $Id: dump.c,v 1.2 2006/05/09 15:44:07 ra3 Exp $ */
/*****************************************************************************/
/**
 * \file   generic_ts/clientlib/src/dump.c
 * \brief  Dump all tasks at task server.
 *
 * \date   04/2004
 * \author Frank Mehnert <fm3@os.inf.tu-dresden.de>
 */
/*****************************************************************************/

/* (c) 2003 Technische Universitaet Dresden
 * This file is part of DROPS, which is distributed under the terms of the
 * GNU General Public License 2. Please see the COPYING file for details. */

#include <l4/log/l4log.h>
#include <l4/env/errno.h>
#include <l4/util/l4_macros.h>
#include <l4/generic_ts/generic_ts.h>
#include <l4/generic_ts/generic_ts-client.h>

#include "debug.h"

int
l4ts_dump_tasks(void)
{
  CORBA_Environment _env = dice_default_environment;

  if (!l4ts_connected())
    return -L4_ENOTFOUND;

  l4_ts_dump_call(&l4ts_server_id, &_env);
  if (DICE_HAS_EXCEPTION(&_env))
    {
      LOGd(DEBUG_TASK, "failed (server=" l4util_idfmt", exc %d)",
	   l4util_idstr(l4ts_server_id), DICE_EXCEPTION_MAJOR(&_env));
      return -L4_EIPC;
    }

  return 0;
}
