#include <l4/sys/kernel.h>
#include <l4/sys/kip.h>
#include "init_kip.h"
#include <stdio.h>
#include <l4/env_support/panic.h>
#include "startup.h"

using L4::Kip::Mem_desc;

extern char _module_data_start;
extern char _module_data_end;

void init_kip_arm(void *k, boot_info_t *bi, l4util_mb_info_t *mbi)
{
  typedef void (*startup_func)(void);
  startup_func f = (startup_func)bi->kernel_start;
  l4_kernel_info_t *kip = (l4_kernel_info_t *)k;
  kip->user_ptr = (unsigned long)mbi;

  kip->sigma0_eip = bi->sigma0_start;
  kip->root_eip   = bi->roottask_start;

  Mem_desc *md = Mem_desc::first(kip);
  (md++)->set(RAM_BASE, RAM_BASE + ((MEMORY << 20) - 1),
      Mem_desc::Conventional);
  (md++)->set(bi->kernel_low, bi->kernel_high - 1, Mem_desc::Reserved);
  (md++)->set(bi->sigma0_low, bi->sigma0_high - 1, Mem_desc::Reserved);
  (md++)->set(bi->roottask_low, bi->roottask_high - 1,Mem_desc::Bootloader);
  (md++)->set(l4_trunc_page(bi->mbi_low), l4_round_page(bi->mbi_high) - 1,
      Mem_desc::Bootloader);

  if (_module_data_start < _module_data_end)
    {
      (md++)->set((l4_umword_t)_module_data_start, 
	  (l4_umword_t)_module_data_end - 1, Mem_desc::Bootloader);
    }

  printf("Starting kernel... (%x)\n", 0);
  f();
  panic("Returned from kernel?!");
}
