IMPLEMENTATION [ux]:

#include "multiboot.h"
#include <cstring>

IMPLEMENT FIASCO_INIT
void
Kip_init::setup_arch()
{
  Multiboot_module *mbm = reinterpret_cast <Multiboot_module*>
    (Kmem::phys_to_virt (Boot_info::mbi_virt()->mods_addr));
  Kip::k()->user_ptr = (unsigned long)(Boot_info::mbi_phys());

  mbm++;
  Kip::k()->sigma0_ip		= mbm->reserved;
  Kip::k()->sigma0_memory.start	= mbm->mod_start & Config::PAGE_MASK;
  Kip::k()->sigma0_memory.end	= ((mbm->mod_end + (Config::PAGE_SIZE-1))
				   & Config::PAGE_MASK);

  mbm++;
  Kip::k()->root_ip		= mbm->reserved;
  Kip::k()->root_memory.start	= mbm->mod_start & Config::PAGE_MASK;
  Kip::k()->root_memory.end	= ((mbm->mod_end + (Config::PAGE_SIZE-1))
				   & Config::PAGE_MASK);

  unsigned long version_size = 0;
  for (char const *v = Kip::k()->version_string(); *v; )
    {
      unsigned l = strlen(v) + 1;
      v += l;
      version_size += l;
    }

  version_size += 2;

  Kip::k()->vhw_offset = sizeof(Kip) + version_size;

  Kip::k()->vhw()->init();
}

IMPLEMENTATION [ux]:

IMPLEMENT inline NEEDS ["kip.h"] FIASCO_INIT
void
Kip_init::setup_arch_abi()
{
  Kip::k()->dedicated[0].start  = Kip::k()->root_memory.start;
  Kip::k()->dedicated[0].end = Kip::k()->root_memory.end;

  for (int i = 1; i < 4; i++)
    Kip::k()->dedicated[i].start = Kip::k()->dedicated[i].end = 0;         
  
  Kip::k()->dedicated[1].start  = ~0UL;
  Kip::k()->dedicated[1].end = 0;
  

  Multiboot_module *mbm = reinterpret_cast <Multiboot_module*>
    (Kmem::phys_to_virt (Boot_info::mbi_virt()->mods_addr));

  for (unsigned i = 3; i < Boot_info::mbi_virt()->mods_count; ++i)
    {
      if (mbm[i].mod_start < Kip::k()->dedicated[1].start)
	Kip::k()->dedicated[1].start = mbm[i].mod_start;

      if (mbm[i].mod_end > Kip::k()->dedicated[1].end)
	Kip::k()->dedicated[1].end = mbm[i].mod_end;
    }
  
  Kip::k()->dedicated[1].start &= ~(Config::PAGE_SIZE - 1);
  Kip::k()->dedicated[1].end = (Kip::k()->dedicated[1].end + 
      Config::PAGE_SIZE -1) & ~(Config::PAGE_SIZE - 1);

  if (Kip::k()->dedicated[1].end <= Kip::k()->dedicated[1].start)
    {
      Kip::k()->dedicated[1].end = 0;
      Kip::k()->dedicated[1].start = 0;
    }
  
  Kip::k()->dedicated[2].start  = Boot_info::mbi_phys();
  Kip::k()->dedicated[2].end = Boot_info::mbi_phys() + Config::PAGE_SIZE;
}
