/**
 *    \file    dice/src/be/sock/SockBEWaitAnyFunction.cpp
 *    \brief   contains the implementation of the class CSockBEWaitAnyFunction
 *
 *    \date    11/28/2002
 *    \author  Ronald Aigner <ra3@os.inf.tu-dresden.de>
 */
/*
 * Copyright (C) 2001-2004
 * Dresden University of Technology, Operating Systems Research Group
 *
 * This file contains free software, you can redistribute it and/or modify
 * it under the terms of the GNU General Public License, Version 2 as
 * published by the Free Software Foundation (see the file COPYING).
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * For different licensing schemes please contact
 * <contact@os.inf.tu-dresden.de>.
 */

#include "be/sock/SockBEWaitAnyFunction.h"
#include "be/BEFile.h"
#include "be/BEContext.h"
#include "be/BEMsgBufferType.h"
#include "be/BEType.h"
#include "be/BEDeclarator.h"
#include "be/sock/BESocket.h"
#include "Compiler.h"

CSockBEWaitAnyFunction::CSockBEWaitAnyFunction(bool bOpenWait, bool bReply)
: CBEWaitAnyFunction(bOpenWait, bReply)
{
}

CSockBEWaitAnyFunction::CSockBEWaitAnyFunction(CSockBEWaitAnyFunction & src)
: CBEWaitAnyFunction(src)
{
}

/** \brief destructor of target class */
CSockBEWaitAnyFunction::~CSockBEWaitAnyFunction()
{

}

/** \brief writes the message invocation
 *  \param pFile the file to write to

 *
 * The socket has to be open already.
 */
void
CSockBEWaitAnyFunction::WriteInvocation(CBEFile * pFile)
{
    // wait for new request
    assert(m_pComm);
    if (m_bReply)
        m_pComm->WriteReplyAndWait(pFile, this);
    else
        m_pComm->WriteWait(pFile, this);
}

/** \brief writes additional variable declarations
 *  \param pFile the file to write to

 */
void CSockBEWaitAnyFunction::WriteVariableDeclaration(CBEFile * pFile)
{
    CBEWaitAnyFunction::WriteVariableDeclaration(pFile);
    pFile->PrintIndent("int dice_ret_size;\n");
    string sObj = CCompiler::GetNameFactory()->GetCorbaObjectVariable();
    pFile->PrintIndent("socklen_t dice_fromlen = sizeof(*%s);\n", sObj.c_str());
}

/** \brief remove references from message buffer
 *  \param pFEInterface the front-end interface to use as reference

 *  \return true on success
 */
bool CSockBEWaitAnyFunction::AddMessageBuffer(CFEInterface * pFEInterface)
{
    if (!CBEWaitAnyFunction::AddMessageBuffer(pFEInterface))
        return false;
    CBEMsgBufferType *pMsgBuffer = GetMessageBuffer();
    assert(pMsgBuffer);
    pMsgBuffer->GetAlias()->IncStars(-pMsgBuffer->GetAlias()->GetStars());
    return true;
}
