/**
 *    \file    dice/src/be/BESrvLoopFunction.h
 *    \brief   contains the declaration of the class CBESrvLoopFunction
 *
 *    \date    01/21/2002
 *    \author  Ronald Aigner <ra3@os.inf.tu-dresden.de>
 */
/*
 * Copyright (C) 2001-2004
 * Dresden University of Technology, Operating Systems Research Group
 *
 * This file contains free software, you can redistribute it and/or modify
 * it under the terms of the GNU General Public License, Version 2 as
 * published by the Free Software Foundation (see the file COPYING).
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * For different licensing schemes please contact
 * <contact@os.inf.tu-dresden.de>.
 */

/** preprocessing symbol to check header file */
#ifndef __DICE_BESRVLOOPFUNCTION_H__
#define __DICE_BESRVLOOPFUNCTION_H__

#include "be/BEInterfaceFunction.h"

class CFEInterface;

class CBEWaitAnyFunction;
class CBEDispatchFunction;

/**    \class CBESrvLoopFunction
 *    \ingroup backend
 *    \brief the wait-any function class for the back-end
 *
 * This class contains the code to write a wait-any function
 */
class CBESrvLoopFunction : public CBEInterfaceFunction
{
// Constructor
public:
    /**    \brief constructor
     */
    CBESrvLoopFunction();
    virtual ~CBESrvLoopFunction();

protected:
    /**    \brief copy constructor */
    CBESrvLoopFunction(CBESrvLoopFunction &src);

public:
    virtual bool CreateBackEnd(CFEInterface *pFEInterface);
    virtual bool DoWriteFunction(CBEHeaderFile* pFile);
    virtual bool DoWriteFunction(CBEImplementationFile* pFile);
    virtual int GetReceiveDirection();
    virtual int GetSendDirection();

protected:
    virtual void WriteLoop(CBEFile *pFile);
    virtual void WriteDispatchInvocation(CBEFile *pFile);
    virtual void WriteAfterParameters(CBEFile *pFile, bool bComma);
    virtual bool WriteBeforeParameters(CBEFile *pFile);
    virtual void WriteBody(CBEFile *pFile);
    virtual void WriteInvocation(CBEFile *pFile);
    virtual void WriteVariableInitialization(CBEFile *pFile);
    virtual void WriteVariableDeclaration(CBEFile *pFile);
    virtual bool AddMessageBuffer(CFEInterface * pFEInterface);
    virtual void WriteEnvironmentInitialization(CBEFile *pFile);
    virtual void WriteFunctionAttributes(CBEFile* pFile);
    virtual void WriteCorbaObjectDeclaration(CBEFile *pFile);
    virtual void WriteCorbaEnvironmentDeclaration(CBEFile *pFile);
    virtual void WriteReturn(CBEFile* pFile);

protected:
    /**    \var CBEWaitAnyFunction *m_pWaitAnyFunction
     *    \brief needed to write wait any function calls
     */
    CBEWaitAnyFunction *m_pWaitAnyFunction;
    /** \var CBEReplyAnyWaitAnyFunction *m_pReplyAnyWaitAnyFunction
     *  \brief needed if default function is used
     */
    CBEWaitAnyFunction *m_pReplyAnyWaitAnyFunction;
    /** \var CBEDispatchFunction *m_pDispatchFunction
     *  \brief dioes the multiplexing of the request
     */
    CBEDispatchFunction *m_pDispatchFunction;
};

#endif // !__DICE_BESRVLOOPFUNCTION_H__
