/**
 *    \file    dice/src/be/BEClassFactory.cpp
 *    \brief   contains the implementation of the class CBEClassFactory
 *
 *    \date    01/10/2002
 *    \author  Ronald Aigner <ra3@os.inf.tu-dresden.de>
 */
/*
 * Copyright (C) 2001-2004
 * Dresden University of Technology, Operating Systems Research Group
 *
 * This file contains free software, you can redistribute it and/or modify
 * it under the terms of the GNU General Public License, Version 2 as
 * published by the Free Software Foundation (see the file COPYING).
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * For different licensing schemes please contact
 * <contact@os.inf.tu-dresden.de>.
 */

#include "be/BEClassFactory.h"
#include "be/BENameFactory.h"
#include "be/BEClassFactory.h"
#include "be/BEContext.h"
#include "be/BEFile.h"
#include "be/BERoot.h"
#include "be/BEClient.h"
#include "be/BEComponent.h"
#include "be/BEHeaderFile.h"
#include "be/BEImplementationFile.h"
#include "be/BEFunction.h"
#include "be/BEOperationFunction.h"
#include "be/BEInterfaceFunction.h"
#include "be/BESndFunction.h"
#include "be/BEWaitFunction.h"
#include "be/BEReplyFunction.h"
#include "be/BECallFunction.h"
#include "be/BEUnmarshalFunction.h"
#include "be/BEMarshalFunction.h"
#include "be/BEComponentFunction.h"
#include "be/BESwitchCase.h"
#include "be/BEWaitAnyFunction.h"
#include "be/BESrvLoopFunction.h"
#include "be/BEAttribute.h"
#include "be/BEType.h"
#include "be/BEOpcodeType.h"
#include "be/BEReplyCodeType.h"
#include "be/BETypedDeclarator.h"
#include "be/BETypedef.h"
#include "be/BEException.h"
#include "be/BEStructType.h"
#include "be/BEMsgBufferType.h"
#include "be/BEUnionType.h"
#include "be/BEUnionCase.h"
#include "be/BEUserDefinedType.h"
#include "be/BEDeclarator.h"
#include "be/BEExpression.h"
#include "be/BEConstant.h"
#include "be/BEClass.h"
#include "be/BEMarshaller.h"
#include "be/BENameSpace.h"
#include "be/BEEnumType.h"
#include "be/BESizes.h"
#include "be/BECommunication.h"
#include "be/BEDispatchFunction.h"
#include "be/BETrace.h"
#include "Compiler.h"
#include "TypeSpec-Type.h"
// for dynamic loadable tracing classes
#include <dlfcn.h>

CBEClassFactory::CBEClassFactory(bool bVerbose)
{
    m_bVerbose = bVerbose;
}

CBEClassFactory::CBEClassFactory(CBEClassFactory & src):CBEObject(src)
{
    m_bVerbose = src.m_bVerbose;
}

/** \brief the destructor of this class */
CBEClassFactory::~CBEClassFactory()
{
}

/** \brief creates a new instance of the class CBERoot
 *  \return a reference to the new instance
 */
CBERoot *CBEClassFactory::GetNewRoot()
{
    if (m_bVerbose)
        printf("CBEClassFactory: created class CBERoot\n");
    return new CBERoot();
}

/** \brief creates a new instance of the class CBEClient
 *  \return a reference to the new instance
 */
CBEClient *CBEClassFactory::GetNewClient()
{
    if (m_bVerbose)
        printf("CBEClassFactory: created class CBEClient\n");
    return new CBEClient();
}

/** \brief creates a new instance of the class CBEComponent
 *  \return a reference to the new instance
 */
CBEComponent *CBEClassFactory::GetNewComponent()
{
    if (m_bVerbose)
        printf("CBEClassFactory: created class CBEComponent\n");
    return new CBEComponent();
}

/** \brief creates a new instance of the class CBEHeaderFile
 *  \return a reference to the new instance
 */
CBEHeaderFile *CBEClassFactory::GetNewHeaderFile()
{
    if (m_bVerbose)
        printf("CBEClassFactory: created class CBEHeaderFile\n");
    return new CBEHeaderFile();
}

/** \brief creates a new instance of the class CBEImplementationFile
 *  \return a reference to the new instance
 */
CBEImplementationFile *CBEClassFactory::GetNewImplementationFile()
{
    if (m_bVerbose)
        printf("CBEClassFactory: created class CBEImplementationFile\n");
    return new CBEImplementationFile();
}

/** \brief creates a new instance of the class CBESndFunction
 *  \return a reference to the new instance
 */
CBESndFunction *CBEClassFactory::GetNewSndFunction()
{
    if (m_bVerbose)
        printf("CBEClassFactory: created class CBESndFunction\n");
    return new CBESndFunction();
}

/** \brief creates a new instance of the class CBEWaitFunction
 *  \return a reference to the new instance
 */
CBEWaitFunction *CBEClassFactory::GetNewRcvFunction()
{
    if (m_bVerbose)
        printf("CBEClassFactory: created class CBEWaitFunction\n");
    return new CBEWaitFunction(false);
}

/** \brief creates a new instance of the class CBEWaitFunction
 *  \return a reference to the new instance
 */
CBEWaitFunction *CBEClassFactory::GetNewWaitFunction()
{
    if (m_bVerbose)
        printf("CBEClassFactory: created class CBEWaitFunction\n");
    return new CBEWaitFunction(true);
}

/** \brief creates a new instance of the class CBEReplyFunction
 *  \return a reference to the new instance
 */
CBEReplyFunction *CBEClassFactory::GetNewReplyFunction()
{
    if (m_bVerbose)
        printf("CBEClassFactory: created class CBEReplyFunction\n");
    return new CBEReplyFunction();
}

/** \brief creates a new instance of the class CBEAttribute
 *  \return a reference to the new instance
 */
CBEAttribute *CBEClassFactory::GetNewAttribute()
{
    if (m_bVerbose)
        printf("CBEClassFactory: created class CBEAttribute\n");
    return new CBEAttribute();
}

/** \brief creates a new instance of the class CBEType
 *  \param nType specifies the front-end type
 *  \return a reference to the new instance
 *
 * The front-end type defines which back-end type class is created.
 */
CBEType *CBEClassFactory::GetNewType(int nType)
{
    switch (nType)
    {
    case TYPE_ARRAY:
    case TYPE_STRUCT:
    case TYPE_TAGGED_STRUCT:
        if (m_bVerbose)
            printf("CBEClassFactory: created class CBEStructType\n");
        return new CBEStructType();
        break;
    case TYPE_UNION:
    case TYPE_TAGGED_UNION:
        if (m_bVerbose)
            printf("CBEClassFactory: created class CBEunionType\n");
        return new CBEUnionType();
        break;
    case TYPE_ENUM:
    case TYPE_TAGGED_ENUM:
        if (m_bVerbose)
            printf("CBEClassFactory: created class CBEEnumType\n");
        return new CBEEnumType();
        break;
    case TYPE_USER_DEFINED:
        if (m_bVerbose)
            printf("CBEClassFactory: created class CBEUserDefinedType\n");
        return GetNewUserDefinedType();
        break;
    case TYPE_NONE:
    case TYPE_FLEXPAGE:
    case TYPE_RCV_FLEXPAGE:
    case TYPE_INTEGER:
    case TYPE_LONG:
    case TYPE_VOID:
    case TYPE_FLOAT:
    case TYPE_DOUBLE:
    case TYPE_LONG_DOUBLE:
    case TYPE_WCHAR:
    case TYPE_CHAR:
    case TYPE_BOOLEAN:
    case TYPE_BYTE:
    case TYPE_VOID_ASTERISK:
    case TYPE_CHAR_ASTERISK:
    case TYPE_PIPE:
    case TYPE_HANDLE_T:
    case TYPE_ISO_LATIN_1:
    case TYPE_ISO_MULTILINGUAL:
    case TYPE_ISO_UCS:
    case TYPE_ERROR_STATUS_T:
    case TYPE_OCTET:
    case TYPE_ANY:
    case TYPE_OBJECT:
    case TYPE_STRING:
    case TYPE_WSTRING:
    case TYPE_REFSTRING:
    default:
        break;
    }
    if (m_bVerbose)
        printf("CBEClassFactory: created class CBEType\n");
    return new CBEType();
}

/** \brief creates a new instance of the class CBETypedDeclarator
 *  \return a reference to the new instance
 */
CBETypedDeclarator *CBEClassFactory::GetNewTypedDeclarator()
{
    if (m_bVerbose)
    printf("CBEClassFactory: created class CBETypedDeclarator\n");
    return new CBETypedDeclarator();
}

/** \brief creates a new instance of the class CBEException
 *  \return a reference to the new instance
 */
CBEException *CBEClassFactory::GetNewException()
{
    if (m_bVerbose)
    printf("CBEClassFactory: created class CBEException\n");
    return new CBEException();
}

/** \brief creates a new instance of the class CBEUnionCase
 *  \return a reference to the new instance
 */
CBEUnionCase *CBEClassFactory::GetNewUnionCase()
{
    if (m_bVerbose)
    printf("CBEClassFactory: created class CBEUnionCase\n");
    return new CBEUnionCase();
}

/** \brief creates a new instance of the class CBEDeclarator
 *  \return a reference to the new instance
 */
CBEDeclarator *CBEClassFactory::GetNewDeclarator()
{
    if (m_bVerbose)
    printf("CBEClassFactory: created class CBEDeclarator\n");
    return new CBEDeclarator();
}

/** \brief creates a new instance of the class CBEExpression
 *  \return a reference to the new instance
 */
CBEExpression *CBEClassFactory::GetNewExpression()
{
    if (m_bVerbose)
    printf("CBEClassFactory: created class CBEExpression\n");
    return new CBEExpression();
}

/** \brief creates a new instance of the class CBETypedef
 *  \return a reference to the new instance
 */
CBETypedef *CBEClassFactory::GetNewTypedef()
{
    if (m_bVerbose)
    printf("CBEClassFactory: created class CBETypedef\n");
    return new CBETypedef();
}

/** \brief creates a new instance of the class CBECallFunction
 *  \return a reference to the new instance
 */
CBECallFunction *CBEClassFactory::GetNewCallFunction()
{
    if (m_bVerbose)
    printf("CBEClassFactory: created class CBECallFunction\n");
    return new CBECallFunction();
}

/** \brief creates a new instance of the class CBEConstant
 *  \return a reference to the new instance
 */
CBEConstant *CBEClassFactory::GetNewConstant()
{
    if (m_bVerbose)
    printf("CBEClassFactory: created class CBEConstant\n");
    return new CBEConstant();
}

/** \brief creates a new instance of the class CBESrvLoopFunction
 *  \return a reference to the new instance
 */
CBESrvLoopFunction *CBEClassFactory::GetNewSrvLoopFunction()
{
    if (m_bVerbose)
    printf("CBEClassFactory: created class CBESrvLoopFunction\n");
    return new CBESrvLoopFunction();
}

/** \brief creates a new instance of the class CBERcvAnyFunction
 *  \return a reference to the new instance
 */
CBEWaitAnyFunction *CBEClassFactory::GetNewRcvAnyFunction()
{
    if (m_bVerbose)
        printf("CBEClassFactory: created class CBERcvAnyFunction\n");
    return new CBEWaitAnyFunction(false, false);
}

/** \brief creates a new instance of the class CBEWaitAnyFunction
 *  \return a reference to the new instance
 */
CBEWaitAnyFunction *CBEClassFactory::GetNewWaitAnyFunction()
{
    if (m_bVerbose)
        printf("CBEClassFactory: created class CBEWaitAnyFunction\n");
    return new CBEWaitAnyFunction(true, false);
}

/** \brief creates a new instance of the class CBEUnmarshalFunction
 *  \return a reference to the new instance
 */
CBEUnmarshalFunction *CBEClassFactory::GetNewUnmarshalFunction()
{
    if (m_bVerbose)
        printf("CBEClassFactory: created class CBEUnmarshalFunction\n");
    return new CBEUnmarshalFunction();
}

/** \brief creates a new instance of the class CBEMarshalFunction
 *  \return a reference to the new instance
 */
CBEMarshalFunction *CBEClassFactory::GetNewMarshalFunction()
{
    if (m_bVerbose)
        printf("CBEClassFactory: created class CBEMarshalFunction\n");
    return new CBEMarshalFunction();
}

/** \brief creates a new instance of the class CBEOpcodeType
 *  \return a reference to the new instance
 */
CBEOpcodeType *CBEClassFactory::GetNewOpcodeType()
{
    if (m_bVerbose)
    printf("CBEClassFactory: created class CBEOpcodeType\n");
    return new CBEOpcodeType();
}

/** \brief creates a new instance of the class CBEOpcodeType
 *  \return a reference to the new instance
 */
CBEReplyCodeType *CBEClassFactory::GetNewReplyCodeType()
{
    if (m_bVerbose)
        printf("CBEClassFactory: created class CBEReplyCodeType\n");
    return new CBEReplyCodeType();
}

/** \brief creates a new instance of the class CBEComponentFunction
 *  \return a reference to the new instance
 */
CBEComponentFunction *CBEClassFactory::GetNewComponentFunction()
{
    if (m_bVerbose)
        printf("CBEClassFactory: created class CBEComponentFunction\n");
    return new CBEComponentFunction();
}

/** \brief creates a new instance of the class CBESwitchCase
 *  \return a reference to the new instance
 */
CBESwitchCase *CBEClassFactory::GetNewSwitchCase()
{
    if (m_bVerbose)
        printf("CBEClassFactory: created class CBESwitchCase\n");
    return new CBESwitchCase();
}

/** \brief creates a new instance of the class CBEMsgBufferType
 *  \param bInterface true if message buffer for an interface, othewise a msgbuf for client
 *  \return a reference to the new instance
 */
CBEMsgBufferType *CBEClassFactory::GetNewMessageBufferType(bool bInterface)
{
    if (m_bVerbose)
        printf("CBEClassFactory: created class CBEMsgBufferType\n");
    return new CBEMsgBufferType();
}

/** \brief creates a new instance of the class CBEUserDefinedType
 *  \return a reference to the new instance
 */
CBEUserDefinedType *CBEClassFactory::GetNewUserDefinedType()
{
    if (m_bVerbose)
        printf("CBEClassFactory: created class CBEUserDefinedType\n");
    return new CBEUserDefinedType();
}

/** \brief creates a new instance of the class CBEClass
 *  \return a reference to the new instance
 */
CBEClass *CBEClassFactory::GetNewClass()
{
    if (m_bVerbose)
        printf("CBEClassFactory: created class CBEClass\n");
    return new CBEClass();
}

/** \brief creates a new instance of the class CBEOperationFunction
 *  \return a reference to the new instance
 */
CBEOperationFunction *CBEClassFactory::GetNewOperationFunction()
{
    if (m_bVerbose)
        printf("CBEClassFactory: created class CBEOperationFunction\n");
    return new CBEOperationFunction();
}

/** \brief creates a new instance of the class CBEMarshaller
 *  \return a reference to the new instance
 */
CBEMarshaller* CBEClassFactory::GetNewMarshaller()
{
    if (m_bVerbose)
        printf("CBEClassFactory: create class CBEMarshaller\n");
    return new CBEMarshaller();
}

/** \brief creates a new instance of the class CBENameSpace
 *  \return a reference to the new instance
 */
CBENameSpace* CBEClassFactory::GetNewNameSpace()
{
    if (m_bVerbose)
        printf("CBEClassFactory: created class CBENameSpace\n");
    return new CBENameSpace();
}

/** \brief creates a new instance of the class CBEReplyAnyWayitAnyFunction
 *  \return a reference to the new instance
 */
CBEWaitAnyFunction* CBEClassFactory::GetNewReplyAnyWaitAnyFunction()
{
    if (m_bVerbose)
        printf("CBEClassFactory: create class CBEReplyAnyWayitAnyFunction\n");
    return new CBEWaitAnyFunction(true /* open wait*/, true /* reply */);
}

/** \brief creates a new instance of the class CBESizes
 *  \return a reference to the new instance
 */
CBESizes* CBEClassFactory::GetNewSizes()
{
    if (m_bVerbose)
        printf("CBEClassFactory: create class CBESizes\n");
    return new CBESizes();
}

/** \brief creates a new instance of the class CBECommunication
 *  \return a reference to the new instance
 */
CBECommunication* CBEClassFactory::GetNewCommunication()
{
    if (m_bVerbose)
        printf("CBEClassFactory: create class CBECommunication\n");
    return new CBECommunication();
}

/** \brief creates a new instance of the class CBEDispatchFunction
 *  \return a reference to the new instance
 */
CBEDispatchFunction* CBEClassFactory::GetNewDispatchFunction()
{
    if (m_bVerbose)
        printf("CBEClassFactory: create class CBEDispatchFunction\n");
    return new CBEDispatchFunction();
}

typedef CBETrace* dice_tracing_new_class_func (void);

/** \brief creates a new instance of the tracing class CBETrace
 *  \return a reference to the tracing class
 */
CBETrace* CBEClassFactory::GetNewTraceFromLib()
{
    string sTraceLib = CCompiler::GetTraceLib();
    if (sTraceLib.empty())
	return (CBETrace*)0;

    // get handle for lib
    void *lib = dlopen(sTraceLib.c_str(), RTLD_NOW);
    if (lib == NULL)
	return (CBETrace*)0;

    // get symbol for create function
    CBETrace* (*func)(void);
    *(void **)(&func) = dlsym(lib, "dice_tracing_new_class");
    // use error message as error indicator
    const char *errmsg = dlerror();
    if (errmsg != NULL)
    {
	fprintf(stderr, "%s\n", errmsg);
	return (CBETrace*)0;
    }
    
    // call factory function
    if (m_bVerbose)
	printf("CBEClassFactory: create class CBETrace from lib \"%s\".\n",
	    sTraceLib.c_str());
    return (*func) ();
}

/** \brief creates a new instance of the class CBETrace
 *  \return a reference to the new instance
 */
CBETrace* CBEClassFactory::GetNewTrace()
{
    CBETrace *pRet = GetNewTraceFromLib();
    if (pRet)
	return pRet;
    if (m_bVerbose)
	printf("CBEClassFactory: create class CBETrace\n");
    return new CBETrace();
}
