#ifndef __L4_SIGMA0_SIGMA0_H
#define __L4_SIGMA0_SIGMA0_H

#include <l4/sys/compiler.h>
#include <l4/sys/types.h>

#undef SIGMA0_REQ_MAGIC
#undef SIGMA0_REQ_MASK

#if defined(ARCH_arm)

# define SIGMA0_REQ_MAGIC		0xE0000000
# define SIGMA0_REQ_MASK		0xF0000000

#elif defined(ARCH_x86)

# define SIGMA0_REQ_MAGIC		0xE0000000
# define SIGMA0_REQ_MASK		0xF0000000

#elif defined(ARCH_amd64)

# define SIGMA0_REQ_MAGIC		0xE0000000
# define SIGMA0_REQ_MASK		0xF0000000

#else

# error Unknown architecture!

#endif

#define SIGMA0_REQ_ID_MASK		0xF0
#define SIGMA0_REQ_ID_FPAGE_CACHED	0x00
#define SIGMA0_REQ_ID_FPAGE_UNCACHED	0x10
#define SIGMA0_REQ_ID_FPAGE_ANY		0x20
#define SIGMA0_REQ_ID_KIP		0x40
#define SIGMA0_REQ_ID_TBUF		0x50

#define SIGMA0_IS_MAGIC_REQ(d1)	\
  ((d1 & SIGMA0_REQ_MASK) == SIGMA0_REQ_MAGIC)

#define SIGMA0_REQ(x)		  (SIGMA0_REQ_MAGIC + x)

/* Use these constants in your code! */
#define SIGMA0_REQ_FPAGE_CACHED	  (SIGMA0_REQ(SIGMA0_REQ_ID_FPAGE_CACHED))
#define SIGMA0_REQ_FPAGE_UNCACHED (SIGMA0_REQ(SIGMA0_REQ_ID_FPAGE_UNCACHED))
#define SIGMA0_REQ_FPAGE_ANY	  (SIGMA0_REQ(SIGMA0_REQ_ID_FPAGE_ANY))
#define SIGMA0_REQ_KIP		  (SIGMA0_REQ(SIGMA0_REQ_ID_KIP))
#define SIGMA0_REQ_TBUF		  (SIGMA0_REQ(SIGMA0_REQ_ID_TBUF))

EXTERN_C_BEGIN

int l4sigma0_map_mem(l4_threadid_t pager,
		     l4_addr_t phys, l4_addr_t virt, l4_addr_t size);

int l4sigma0_map_iomem(l4_threadid_t pager,
		       l4_addr_t phys, l4_addr_t virt, l4_addr_t size);

int l4sigma0_map_anypage(l4_threadid_t pager, l4_addr_t map_area,
			 unsigned log2_map_size, l4_addr_t *base);

int l4sigma0_map_tbuf(l4_threadid_t pager, l4_addr_t virt);

static inline char *l4sigma0_map_errstr(int err)
{
  switch (err)
    {
    case  0: return "No error";
    case -1: return "Phys, virt or size not aligned";
    case -2: return "IPC error";
    case -3: return "No fpage received";
#ifndef SIGMA0_REQ_MAGIC
    case -4: return "Bad physical address (old protocol only)";
#endif
    case -6: return "Superpage requested but smaller flexpage received";
    default: return "Unknown error";
    }
}

EXTERN_C_END

#endif /* ! __L4_SIGMA0_SIGMA0_H */
